/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.ClientCredentialsValidator;
import com.sap.cloud.sdk.cloudplatform.CloudPlatform;
import com.sap.cloud.sdk.cloudplatform.CloudPlatformAccessor;
import com.sap.cloud.sdk.cloudplatform.ScpCfCloudPlatform;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceDecorator;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceIsolationMode;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenDecoder;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenFacade;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenRequest;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenThreadContextListener;
import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestDeniedException;
import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestFailedException;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestAccessor;
import com.sap.cloud.sdk.cloudplatform.thread.Property;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextAccessor;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.config.cf.CFConstants;
import com.sap.cloud.security.config.cf.CFEnvironment;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.validation.CombiningValidator;
import com.sap.cloud.security.token.validation.validators.JwtValidatorBuilder;
import com.sap.cloud.security.xsuaa.client.ClientCredentials;
import com.sap.cloud.security.xsuaa.client.DefaultOAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.XsuaaDefaultEndpoints;
import com.sap.cloud.security.xsuaa.tokenflows.UserTokenFlow;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlows;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthTokenFacade
implements AuthTokenFacade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultAuthTokenFacade.class);
    @Nonnull
    static final OAuth2TokenService defaultTokenService = new DefaultOAuth2TokenService();
    @Nonnull
    static final List<CombiningValidator<Token>> defaultValidators = DefaultAuthTokenFacade.loadXsuaaValidators(DefaultAuthTokenFacade.loadXsuaaConfigurations());
    @Nonnull
    private final OAuth2TokenService tokenService;
    @Nonnull
    private final List<CombiningValidator<Token>> tokenValidators;

    public DefaultAuthTokenFacade() {
        this(defaultTokenService, defaultValidators);
    }

    public DefaultAuthTokenFacade(@Nonnull OAuth2TokenService tokenService, @Nullable OAuth2ServiceConfiguration xsuaaConfiguration) {
        this(tokenService, (List)Option.of((Object)xsuaaConfiguration).onEmpty(() -> log.warn("AuthTokenFacade instantiated without an XSUAA configuration.")).map(DefaultAuthTokenFacade::getXsuaaValidator).map(Collections::singletonList).getOrElse(Collections::emptyList));
    }

    private DefaultAuthTokenFacade(@Nonnull OAuth2TokenService tokenService, @Nonnull List<CombiningValidator<Token>> tokenValidators) {
        this.tokenService = tokenService;
        this.tokenValidators = tokenValidators;
    }

    @Override
    @Nonnull
    public Try<AuthToken> tryGetCurrentToken() {
        AuthTokenDecoder authTokenDecoder = this.getAuthTokenDecoder();
        return ThreadContextAccessor.tryGetCurrentContext().flatMap(context -> context.getProperty(AuthTokenThreadContextListener.PROPERTY_AUTH_TOKEN)).map(Property::getValue).orElse(() -> RequestAccessor.tryGetCurrentRequest().flatMap(authTokenDecoder::decodeAndValidate));
    }

    @Override
    @Nonnull
    public Try<AuthToken> tryGetXsuaaServiceToken() {
        AuthTokenDecoder authTokenDecoder = this.getAuthTokenDecoder();
        return Try.of((CheckedFunction0 & Serializable)() -> new AuthTokenRequest(authTokenDecoder, this.tokenService).getXsuaaServiceToken());
    }

    @Override
    @Nonnull
    public Future<String> getRefreshToken(@Nonnull DecodedJWT jwt) {
        Callable tokenCallable = ResilienceDecorator.decorateCallable(() -> this.sendTokenRequestAndParseResponse(jwt), (ResilienceConfiguration)ResilienceConfiguration.of(DefaultAuthTokenFacade.class).isolationMode(ResilienceIsolationMode.NO_ISOLATION).timeLimiterConfiguration(ResilienceConfiguration.TimeLimiterConfiguration.of().timeoutDuration(Duration.ofSeconds(6L))).circuitBreakerConfiguration(ResilienceConfiguration.CircuitBreakerConfiguration.of().waitDuration(Duration.ofSeconds(6L))));
        FutureTask<String> tokenFuture = new FutureTask<String>(tokenCallable);
        tokenFuture.run();
        return tokenFuture;
    }

    @Nonnull
    private String sendTokenRequestAndParseResponse(@Nonnull DecodedJWT jwt) throws TokenRequestDeniedException, TokenRequestFailedException {
        CloudPlatform cloudPlatform = CloudPlatformAccessor.getCloudPlatform();
        if (!(cloudPlatform instanceof ScpCfCloudPlatform)) {
            throw new ShouldNotHappenException("The current Cloud platform is not an instance of " + ScpCfCloudPlatform.class.getSimpleName() + ". Please make sure to specify a dependency to com.sap.cloud.sdk.cloudplatform:cloudplatform-core-scp-cf.");
        }
        JsonObject xsuaaCreds = ((ScpCfCloudPlatform)cloudPlatform).getXsuaaServiceCredentials(jwt);
        BiFunction<String, UnaryOperator, String> fromXsuaa = (key, op) -> (String)Objects.requireNonNull(op.apply(xsuaaCreds.get(key).getAsString()), key);
        String xsuaaUrl = fromXsuaa.apply("url", UnaryOperator.identity());
        String clientId = fromXsuaa.apply("clientid", ClientCredentialsValidator::ensureClientId);
        String clientSecret = fromXsuaa.apply("clientsecret", ClientCredentialsValidator::ensureClientSecret);
        List jwtScopes = jwt.getClaim("scope").asList(String.class);
        boolean jwtHasUaaUserScope = jwtScopes.stream().anyMatch(scope -> scope.equals("uaa.user"));
        if (!jwtHasUaaUserScope) {
            throw new TokenRequestDeniedException("Unable to get access token: user does not have scope 'uaa.user'. This is mandatory for the user token flow. Please make sure to that this scope is assigned to the user.");
        }
        String authorizationBearer = jwt.getToken();
        UserTokenFlow userTokenFlow = new XsuaaTokenFlows(this.tokenService, (OAuth2ServiceEndpointsProvider)new XsuaaDefaultEndpoints(URI.create(xsuaaUrl)), new ClientCredentials(clientId, clientSecret)).userTokenFlow().token(authorizationBearer);
        return (String)Try.of((CheckedFunction0 & Serializable)() -> userTokenFlow.execute().getRefreshToken()).filter(Objects::nonNull, () -> new TokenRequestFailedException("Failed to get access token: no valid refresh token found in response of user token flow. Please make sure to correctly bind your application to a XSUAA service instance.")).getOrElseThrow(e -> new TokenRequestFailedException("Refresh JWT request failed", (Throwable)e));
    }

    @Nonnull
    static CombiningValidator<Token> getXsuaaValidator(@Nonnull OAuth2ServiceConfiguration xsuaaConfiguration) {
        return JwtValidatorBuilder.getInstance((OAuth2ServiceConfiguration)xsuaaConfiguration).build();
    }

    @Nonnull
    static List<CombiningValidator<Token>> loadXsuaaValidators(@Nonnull List<OAuth2ServiceConfiguration> xsuaaConfigurations) {
        if (xsuaaConfigurations.isEmpty()) {
            log.debug("No JWT validators were registered since no XSUAA configuration could be loaded.");
        }
        return xsuaaConfigurations.stream().map(DefaultAuthTokenFacade::getXsuaaValidator).collect(Collectors.toList());
    }

    @Nonnull
    private static List<OAuth2ServiceConfiguration> loadXsuaaConfigurations() {
        Try environment = Try.of(CFEnvironment::getInstance);
        if (environment.isSuccess()) {
            List<OAuth2ServiceConfiguration> configurations = EnumSet.allOf(CFConstants.Plan.class).stream().map(p -> ((CFEnvironment)environment.get()).loadForServicePlan(Service.XSUAA, p)).filter(Objects::nonNull).peek(c -> log.debug("Found XSUAA service binding with plan {}, client id {} and application id {}.", new Object[]{c.getProperty("plan"), c.getClientId(), c.getProperty("xsappname")})).collect(Collectors.toList());
            if (configurations.isEmpty()) {
                log.warn("Could not find any XSUAA service bindings.");
            }
            return configurations;
        }
        log.error("Failed to read environment data for XSUAA configuration.", environment.getCause());
        return Collections.emptyList();
    }

    AuthTokenDecoder getAuthTokenDecoder() {
        return new AuthTokenDecoder(this.tokenService, this.tokenValidators);
    }
}

