/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.sap.cloud.sdk.cloudplatform.security.BasicAuthenticationFacade;
import com.sap.cloud.sdk.cloudplatform.security.BasicAuthenticationThreadContextListener;
import com.sap.cloud.sdk.cloudplatform.security.BasicCredentials;
import com.sap.cloud.sdk.cloudplatform.security.exception.BasicAuthenticationAccessException;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestAccessor;
import com.sap.cloud.sdk.cloudplatform.thread.Property;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContext;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextAccessor;
import io.vavr.control.Try;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;

public class DefaultBasicAuthenticationFacade
implements BasicAuthenticationFacade {
    private static final Pattern CASE_INSENSITIVE_BASIC_PREFIX_MATCH = Pattern.compile("^(?i)basic(?-i) \\s*([A-Za-z0-9+/=]+)\\s*$");

    @Override
    @Nonnull
    public Try<BasicCredentials> tryGetBasicCredentials() {
        return this.readBasicCredentialsFromContext().orElse(this::extractBasicCredentialsFromRequest);
    }

    private Try<BasicCredentials> readBasicCredentialsFromContext() {
        return ThreadContextAccessor.tryGetCurrentContext().flatMap(this::extractBasicCredentialsProperty).map(Property::getValue);
    }

    private Try<Property<BasicCredentials>> extractBasicCredentialsProperty(ThreadContext context) {
        return context.getProperty(BasicAuthenticationThreadContextListener.PROPERTY_BASIC_AUTH_HEADER);
    }

    private Try<BasicCredentials> extractBasicCredentialsFromRequest() {
        return RequestAccessor.tryGetCurrentRequest().map(this::extractAuthorizationHeaders).map(this::selectBasicAuthenticationHeader).map(this::extractBasicHeaderValue).map(this::decodeBasicCredentials);
    }

    private List<String> extractAuthorizationHeaders(HttpServletRequest request) {
        Enumeration headers = request.getHeaders("Authorization");
        if (headers == null) {
            throw new BasicAuthenticationAccessException("Received no 'Authorization' headers with the request.");
        }
        return Collections.list(headers);
    }

    private String selectBasicAuthenticationHeader(List<String> allAuthenticationHeader) {
        if (allAuthenticationHeader.isEmpty()) {
            throw new BasicAuthenticationAccessException("Received an 'Authorization' header without a value.");
        }
        if (allAuthenticationHeader.size() > 1) {
            throw new BasicAuthenticationAccessException("Received multiple 'Authorization' headers with the request, but the specification allows at most one.");
        }
        return allAuthenticationHeader.get(0);
    }

    private String extractBasicHeaderValue(CharSequence completeHeader) {
        Matcher match = CASE_INSENSITIVE_BASIC_PREFIX_MATCH.matcher(completeHeader);
        if (!match.matches()) {
            throw new BasicAuthenticationAccessException("The 'Authorization' header did not contain a Basic Authentication header field.");
        }
        return match.group(1);
    }

    private BasicCredentials decodeBasicCredentials(String base64Credentials) {
        String[] credentials = new String(Base64.getDecoder().decode(base64Credentials), StandardCharsets.UTF_8).split(":");
        return new BasicCredentials(credentials[0], credentials[1]);
    }
}

