/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.CloudPlatform;
import com.sap.cloud.sdk.cloudplatform.CloudPlatformAccessor;
import com.sap.cloud.sdk.cloudplatform.ScpCfCloudPlatform;
import com.sap.cloud.sdk.cloudplatform.exception.CloudPlatformException;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenAccessor;
import com.sap.cloud.sdk.cloudplatform.security.ClientCertificate;
import com.sap.cloud.sdk.cloudplatform.security.ClientCredentials;
import com.sap.cloud.sdk.cloudplatform.security.Credentials;
import com.sap.cloud.sdk.cloudplatform.security.K8sWorkarounds;
import com.sap.cloud.sdk.cloudplatform.security.OAuth2ServiceProvider;
import com.sap.cloud.sdk.cloudplatform.security.OAuth2ServiceSettings;
import com.sap.cloud.sdk.cloudplatform.security.OAuth2TokenServiceCache;
import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.config.cf.CFConstants;
import com.sap.cloud.security.config.cf.CFEnvironment;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.XsuaaDefaultEndpoints;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlows;
import io.vavr.Lazy;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultOAuth2ServiceProvider
implements OAuth2ServiceProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultOAuth2ServiceProvider.class);
    @Nonnull
    private final CloudPlatform platform;
    @Nonnull
    private final OAuth2TokenServiceCache tokenServiceCache;
    @Nullable
    private final OAuth2TokenService staticTokenService;
    @Nullable
    private final ClientIdentity staticClientIdentity;
    @Nullable
    private final OAuth2ServiceEndpointsProvider staticEndpointsProvider;
    @Nullable
    private final DecodedJWT staticAccessToken;
    @Nonnull
    private final Lazy<CFEnvironment> cfEnvironment = Lazy.of(this::createEnvironment);

    private DefaultOAuth2ServiceProvider(@Nullable OAuth2TokenServiceCache tokenServiceCache, @Nullable CloudPlatform platform, @Nullable OAuth2TokenService staticTokenService, @Nullable DecodedJWT staticAccessToken, @Nullable Credentials staticCredentials, @Nullable OAuth2ServiceSettings serviceSettings) {
        this.staticClientIdentity = staticCredentials == null ? null : DefaultOAuth2ServiceProvider.getClientIdentity(staticCredentials);
        this.staticEndpointsProvider = serviceSettings == null ? null : serviceSettings.toOAuth2Endpoints();
        this.platform = platform != null ? platform : CloudPlatformAccessor.getCloudPlatform();
        this.tokenServiceCache = tokenServiceCache != null ? tokenServiceCache : OAuth2TokenServiceCache.create();
        this.staticAccessToken = staticAccessToken;
        this.staticTokenService = staticTokenService;
    }

    @Nonnull
    private static ClientIdentity getClientIdentity(@Nonnull Credentials credentials) {
        if (credentials instanceof ClientCredentials) {
            return new com.sap.cloud.security.config.ClientCredentials(((ClientCredentials)credentials).getClientId(), ((ClientCredentials)credentials).getClientSecret());
        }
        if (credentials instanceof ClientCertificate) {
            return new com.sap.cloud.security.config.ClientCertificate(((ClientCertificate)credentials).getCertificate(), ((ClientCertificate)credentials).getKey(), ((ClientCertificate)credentials).getClientId());
        }
        throw new IllegalStateException("Unsupported credentials type for authenticating against OAuth2 endpoint: " + credentials.getClass().getSimpleName());
    }

    @Nonnull
    OAuth2ServiceConfiguration getCurrentServiceConfiguration() {
        CFEnvironment environment = (CFEnvironment)this.cfEnvironment.get();
        if (environment.getXsuaaConfiguration() == null && environment.getIasConfiguration() == null) {
            throw new CloudPlatformException("No XSUAA or IAS bindings found.");
        }
        DecodedJWT jwt = this.staticAccessToken != null ? this.staticAccessToken : DefaultOAuth2ServiceProvider.getCurrentAccessToken();
        String plan = DefaultOAuth2ServiceProvider.getCurrentXsuaaServicePlan(this.platform, jwt);
        if (plan == null) {
            log.debug("Could not find any XSUAA service binding matching the current user access token. Falling back to default XSUAA binding.");
            return Objects.requireNonNull(environment.getXsuaaConfiguration(), "No XSUAA bindings found.");
        }
        OAuth2ServiceConfiguration conf = environment.loadForServicePlan(Service.XSUAA, CFConstants.Plan.from((String)plan));
        if (conf == null) {
            throw new IllegalStateException("Unable to load XSUAA service information for plan " + plan);
        }
        return conf;
    }

    @Nullable
    private static String getCurrentXsuaaServicePlan(@Nonnull CloudPlatform platform, @Nullable DecodedJWT jwt) {
        Map<String, List<JsonObject>> serviceBindings = DefaultOAuth2ServiceProvider.getCurrentXsuaaServiceCredentials(platform, jwt);
        if (serviceBindings.size() > 1) {
            log.warn("Found more than one matching XSUAA service binding plan for provided token.");
        }
        return serviceBindings.isEmpty() ? null : serviceBindings.keySet().iterator().next();
    }

    @Nonnull
    private static Map<String, List<JsonObject>> getCurrentXsuaaServiceCredentials(@Nonnull CloudPlatform platform, @Nullable DecodedJWT jwt) throws CloudPlatformException {
        Map result = DefaultOAuth2ServiceProvider.castScpCfPlatform(platform).getXsuaaCredentialsByPlan(jwt);
        if (result.isEmpty()) {
            if (jwt != null) {
                log.debug("Unable to find matching XSUAA service binding for token: {}", (Object)jwt.getToken());
            } else {
                log.debug("Unable to find any XSUAA service binding.");
            }
        }
        return result;
    }

    @Nonnull
    private CFEnvironment createEnvironment() {
        UnaryOperator environmentOperator;
        if (this.platform instanceof ScpCfCloudPlatform) {
            environmentOperator = name -> K8sWorkarounds.getEnvironmentVariable((ScpCfCloudPlatform)this.platform, name);
        } else {
            environmentOperator = System::getenv;
            log.warn("Provided platform object is not of type {}.", (Object)ScpCfCloudPlatform.class.getSimpleName());
        }
        return CFEnvironment.getInstance((UnaryOperator)environmentOperator, System::getProperty);
    }

    @Nonnull
    private static ScpCfCloudPlatform castScpCfPlatform(@Nonnull CloudPlatform platform) {
        if (!(platform instanceof ScpCfCloudPlatform)) {
            throw new CloudPlatformException("This operation requires a platform instance of type: " + ScpCfCloudPlatform.class.getSimpleName());
        }
        return (ScpCfCloudPlatform)platform;
    }

    @Nullable
    private static DecodedJWT getCurrentAccessToken() {
        return (DecodedJWT)AuthTokenAccessor.tryGetCurrentToken().map(AuthToken::getJwt).onFailure(e -> log.debug("Current user access token not found.")).getOrNull();
    }

    @Override
    @Nonnull
    public XsuaaTokenFlows getXsuaaTokenFlows() {
        OAuth2ServiceEndpointsProvider endpointsProvider;
        OAuth2TokenService tokenService;
        ClientIdentity clientIdentity;
        OAuth2ServiceConfiguration currentServiceConfiguration = null;
        if (this.staticClientIdentity == null || this.staticEndpointsProvider == null) {
            currentServiceConfiguration = this.getCurrentServiceConfiguration();
        }
        if ((clientIdentity = this.staticClientIdentity) == null) {
            clientIdentity = currentServiceConfiguration.getClientIdentity();
        }
        if ((tokenService = this.staticTokenService) == null) {
            tokenService = this.tokenServiceCache.getTokenService(clientIdentity);
        }
        if ((endpointsProvider = this.staticEndpointsProvider) == null) {
            endpointsProvider = new XsuaaDefaultEndpoints(currentServiceConfiguration);
        }
        return new XsuaaTokenFlows(tokenService, endpointsProvider, clientIdentity);
    }

    @Nonnull
    @Generated
    public static DefaultOAuth2ServiceProviderBuilder builder() {
        return new DefaultOAuth2ServiceProviderBuilder();
    }

    @Nonnull
    @Generated
    public CloudPlatform getPlatform() {
        return this.platform;
    }

    @Nonnull
    @Generated
    public OAuth2TokenServiceCache getTokenServiceCache() {
        return this.tokenServiceCache;
    }

    @Nullable
    @Generated
    public OAuth2TokenService getStaticTokenService() {
        return this.staticTokenService;
    }

    @Nullable
    @Generated
    public ClientIdentity getStaticClientIdentity() {
        return this.staticClientIdentity;
    }

    @Nullable
    @Generated
    public OAuth2ServiceEndpointsProvider getStaticEndpointsProvider() {
        return this.staticEndpointsProvider;
    }

    @Nullable
    @Generated
    public DecodedJWT getStaticAccessToken() {
        return this.staticAccessToken;
    }

    @Nonnull
    @Generated
    public Lazy<CFEnvironment> getCfEnvironment() {
        return this.cfEnvironment;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultOAuth2ServiceProvider)) {
            return false;
        }
        DefaultOAuth2ServiceProvider other = (DefaultOAuth2ServiceProvider)o;
        CloudPlatform this$platform = this.getPlatform();
        CloudPlatform other$platform = other.getPlatform();
        if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
            return false;
        }
        OAuth2TokenServiceCache this$tokenServiceCache = this.getTokenServiceCache();
        OAuth2TokenServiceCache other$tokenServiceCache = other.getTokenServiceCache();
        if (this$tokenServiceCache == null ? other$tokenServiceCache != null : !this$tokenServiceCache.equals(other$tokenServiceCache)) {
            return false;
        }
        OAuth2TokenService this$staticTokenService = this.getStaticTokenService();
        OAuth2TokenService other$staticTokenService = other.getStaticTokenService();
        if (this$staticTokenService == null ? other$staticTokenService != null : !this$staticTokenService.equals(other$staticTokenService)) {
            return false;
        }
        ClientIdentity this$staticClientIdentity = this.getStaticClientIdentity();
        ClientIdentity other$staticClientIdentity = other.getStaticClientIdentity();
        if (this$staticClientIdentity == null ? other$staticClientIdentity != null : !this$staticClientIdentity.equals(other$staticClientIdentity)) {
            return false;
        }
        OAuth2ServiceEndpointsProvider this$staticEndpointsProvider = this.getStaticEndpointsProvider();
        OAuth2ServiceEndpointsProvider other$staticEndpointsProvider = other.getStaticEndpointsProvider();
        if (this$staticEndpointsProvider == null ? other$staticEndpointsProvider != null : !this$staticEndpointsProvider.equals(other$staticEndpointsProvider)) {
            return false;
        }
        DecodedJWT this$staticAccessToken = this.getStaticAccessToken();
        DecodedJWT other$staticAccessToken = other.getStaticAccessToken();
        if (this$staticAccessToken == null ? other$staticAccessToken != null : !this$staticAccessToken.equals(other$staticAccessToken)) {
            return false;
        }
        Lazy<CFEnvironment> this$cfEnvironment = this.getCfEnvironment();
        Lazy<CFEnvironment> other$cfEnvironment = other.getCfEnvironment();
        return !(this$cfEnvironment == null ? other$cfEnvironment != null : !this$cfEnvironment.equals(other$cfEnvironment));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CloudPlatform $platform = this.getPlatform();
        result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
        OAuth2TokenServiceCache $tokenServiceCache = this.getTokenServiceCache();
        result = result * 59 + ($tokenServiceCache == null ? 43 : $tokenServiceCache.hashCode());
        OAuth2TokenService $staticTokenService = this.getStaticTokenService();
        result = result * 59 + ($staticTokenService == null ? 43 : $staticTokenService.hashCode());
        ClientIdentity $staticClientIdentity = this.getStaticClientIdentity();
        result = result * 59 + ($staticClientIdentity == null ? 43 : $staticClientIdentity.hashCode());
        OAuth2ServiceEndpointsProvider $staticEndpointsProvider = this.getStaticEndpointsProvider();
        result = result * 59 + ($staticEndpointsProvider == null ? 43 : $staticEndpointsProvider.hashCode());
        DecodedJWT $staticAccessToken = this.getStaticAccessToken();
        result = result * 59 + ($staticAccessToken == null ? 43 : $staticAccessToken.hashCode());
        Lazy<CFEnvironment> $cfEnvironment = this.getCfEnvironment();
        result = result * 59 + ($cfEnvironment == null ? 43 : $cfEnvironment.hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "DefaultOAuth2ServiceProvider(platform=" + this.getPlatform() + ", tokenServiceCache=" + this.getTokenServiceCache() + ", staticTokenService=" + this.getStaticTokenService() + ", staticClientIdentity=" + this.getStaticClientIdentity() + ", staticEndpointsProvider=" + this.getStaticEndpointsProvider() + ", staticAccessToken=" + this.getStaticAccessToken() + ", cfEnvironment=" + this.getCfEnvironment() + ")";
    }

    static class DefaultOAuth2ServiceProviderBuilder
    implements OAuth2ServiceProvider.OAuth2ServiceProviderBuilder {
        @Generated
        private OAuth2TokenServiceCache tokenServiceCache;
        @Generated
        private CloudPlatform platform;
        @Generated
        private OAuth2TokenService staticTokenService;
        @Generated
        private DecodedJWT staticAccessToken;
        @Generated
        private Credentials staticCredentials;
        @Generated
        private OAuth2ServiceSettings serviceSettings;

        @Generated
        DefaultOAuth2ServiceProviderBuilder() {
        }

        @Override
        @Nonnull
        @Generated
        public DefaultOAuth2ServiceProviderBuilder tokenServiceCache(@Nullable OAuth2TokenServiceCache tokenServiceCache) {
            this.tokenServiceCache = tokenServiceCache;
            return this;
        }

        @Override
        @Nonnull
        @Generated
        public DefaultOAuth2ServiceProviderBuilder platform(@Nullable CloudPlatform platform) {
            this.platform = platform;
            return this;
        }

        @Nonnull
        @Generated
        public DefaultOAuth2ServiceProviderBuilder staticTokenService(@Nullable OAuth2TokenService staticTokenService) {
            this.staticTokenService = staticTokenService;
            return this;
        }

        @Override
        @Nonnull
        @Generated
        public DefaultOAuth2ServiceProviderBuilder staticAccessToken(@Nullable DecodedJWT staticAccessToken) {
            this.staticAccessToken = staticAccessToken;
            return this;
        }

        @Override
        @Nonnull
        @Generated
        public DefaultOAuth2ServiceProviderBuilder staticCredentials(@Nullable Credentials staticCredentials) {
            this.staticCredentials = staticCredentials;
            return this;
        }

        @Override
        @Nonnull
        @Generated
        public DefaultOAuth2ServiceProviderBuilder serviceSettings(@Nullable OAuth2ServiceSettings serviceSettings) {
            this.serviceSettings = serviceSettings;
            return this;
        }

        @Override
        @Nonnull
        @Generated
        public DefaultOAuth2ServiceProvider build() {
            return new DefaultOAuth2ServiceProvider(this.tokenServiceCache, this.platform, this.staticTokenService, this.staticAccessToken, this.staticCredentials, this.serviceSettings);
        }

        @Nonnull
        @Generated
        public String toString() {
            return "DefaultOAuth2ServiceProvider.DefaultOAuth2ServiceProviderBuilder(tokenServiceCache=" + this.tokenServiceCache + ", platform=" + this.platform + ", staticTokenService=" + this.staticTokenService + ", staticAccessToken=" + this.staticAccessToken + ", staticCredentials=" + this.staticCredentials + ", serviceSettings=" + this.serviceSettings + ")";
        }
    }
}

