/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.util.UriUtil;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class OAuth2ServiceSettings {
    private static final String TOKEN_PATH = "/oauth/token";
    private static final String AUTHORIZE_PATH = "/oauth/authorize";
    private static final String KEYSET_PATH = "/token_keys";
    @Nonnull
    private final URI baseUri;
    @Nullable
    private final String tokenPath;
    @Nullable
    private final String authorizePath;
    @Nullable
    private final String keysetPath;

    @Nonnull
    OAuth2ServiceEndpointsProvider toOAuth2Endpoints() {
        return new OAuth2ServiceEndpointsProvider(){
            @Nonnull
            final URI tokenEndpoint;
            @Nonnull
            final URI authorizeEndpoint;
            @Nonnull
            final URI jwksUri;
            {
                this.tokenEndpoint = UriUtil.expandPath((URI)OAuth2ServiceSettings.this.baseUri, (String)(OAuth2ServiceSettings.this.tokenPath != null ? OAuth2ServiceSettings.this.tokenPath : OAuth2ServiceSettings.TOKEN_PATH));
                this.authorizeEndpoint = UriUtil.expandPath((URI)OAuth2ServiceSettings.this.baseUri, (String)(OAuth2ServiceSettings.this.authorizePath != null ? OAuth2ServiceSettings.this.authorizePath : OAuth2ServiceSettings.AUTHORIZE_PATH));
                this.jwksUri = UriUtil.expandPath((URI)OAuth2ServiceSettings.this.baseUri, (String)(OAuth2ServiceSettings.this.keysetPath != null ? OAuth2ServiceSettings.this.keysetPath : OAuth2ServiceSettings.KEYSET_PATH));
            }

            @Nonnull
            @Generated
            public URI getTokenEndpoint() {
                return this.tokenEndpoint;
            }

            @Nonnull
            @Generated
            public URI getAuthorizeEndpoint() {
                return this.authorizeEndpoint;
            }

            @Nonnull
            @Generated
            public URI getJwksUri() {
                return this.jwksUri;
            }
        };
    }

    @Nonnull
    public static OAuth2ServiceSettingsBuilder ofBaseUri(@Nonnull URI baseUri) {
        return OAuth2ServiceSettings.builder().baseUri(baseUri);
    }

    @Nonnull
    private static OAuth2ServiceSettingsBuilder builder() {
        return new OAuth2ServiceSettingsBuilder();
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2ServiceSettings)) {
            return false;
        }
        OAuth2ServiceSettings other = (OAuth2ServiceSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URI this$baseUri = this.getBaseUri();
        URI other$baseUri = other.getBaseUri();
        if (this$baseUri == null ? other$baseUri != null : !((Object)this$baseUri).equals(other$baseUri)) {
            return false;
        }
        String this$tokenPath = this.getTokenPath();
        String other$tokenPath = other.getTokenPath();
        if (this$tokenPath == null ? other$tokenPath != null : !this$tokenPath.equals(other$tokenPath)) {
            return false;
        }
        String this$authorizePath = this.getAuthorizePath();
        String other$authorizePath = other.getAuthorizePath();
        if (this$authorizePath == null ? other$authorizePath != null : !this$authorizePath.equals(other$authorizePath)) {
            return false;
        }
        String this$keysetPath = this.getKeysetPath();
        String other$keysetPath = other.getKeysetPath();
        return !(this$keysetPath == null ? other$keysetPath != null : !this$keysetPath.equals(other$keysetPath));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof OAuth2ServiceSettings;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $baseUri = this.getBaseUri();
        result = result * 59 + ($baseUri == null ? 43 : ((Object)$baseUri).hashCode());
        String $tokenPath = this.getTokenPath();
        result = result * 59 + ($tokenPath == null ? 43 : $tokenPath.hashCode());
        String $authorizePath = this.getAuthorizePath();
        result = result * 59 + ($authorizePath == null ? 43 : $authorizePath.hashCode());
        String $keysetPath = this.getKeysetPath();
        result = result * 59 + ($keysetPath == null ? 43 : $keysetPath.hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "OAuth2ServiceSettings(baseUri=" + this.getBaseUri() + ", tokenPath=" + this.getTokenPath() + ", authorizePath=" + this.getAuthorizePath() + ", keysetPath=" + this.getKeysetPath() + ")";
    }

    @Generated
    protected OAuth2ServiceSettings(@Nonnull URI baseUri, @Nullable String tokenPath, @Nullable String authorizePath, @Nullable String keysetPath) {
        if (baseUri == null) {
            throw new NullPointerException("baseUri is marked non-null but is null");
        }
        this.baseUri = baseUri;
        this.tokenPath = tokenPath;
        this.authorizePath = authorizePath;
        this.keysetPath = keysetPath;
    }

    @Nonnull
    @Generated
    public URI getBaseUri() {
        return this.baseUri;
    }

    @Nullable
    @Generated
    public String getTokenPath() {
        return this.tokenPath;
    }

    @Nullable
    @Generated
    public String getAuthorizePath() {
        return this.authorizePath;
    }

    @Nullable
    @Generated
    public String getKeysetPath() {
        return this.keysetPath;
    }

    @Generated
    public static class OAuth2ServiceSettingsBuilder {
        @Generated
        private URI baseUri;
        @Generated
        private String tokenPath;
        @Generated
        private String authorizePath;
        @Generated
        private String keysetPath;

        @Generated
        OAuth2ServiceSettingsBuilder() {
        }

        @Nonnull
        @Generated
        public OAuth2ServiceSettingsBuilder baseUri(@Nonnull URI baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        @Nonnull
        @Generated
        public OAuth2ServiceSettingsBuilder tokenPath(@Nullable String tokenPath) {
            this.tokenPath = tokenPath;
            return this;
        }

        @Nonnull
        @Generated
        public OAuth2ServiceSettingsBuilder authorizePath(@Nullable String authorizePath) {
            this.authorizePath = authorizePath;
            return this;
        }

        @Nonnull
        @Generated
        public OAuth2ServiceSettingsBuilder keysetPath(@Nullable String keysetPath) {
            this.keysetPath = keysetPath;
            return this;
        }

        @Nonnull
        @Generated
        public OAuth2ServiceSettings build() {
            return new OAuth2ServiceSettings(this.baseUri, this.tokenPath, this.authorizePath, this.keysetPath);
        }

        @Nonnull
        @Generated
        public String toString() {
            return "OAuth2ServiceSettings.OAuth2ServiceSettingsBuilder(baseUri=" + this.baseUri + ", tokenPath=" + this.tokenPath + ", authorizePath=" + this.authorizePath + ", keysetPath=" + this.keysetPath + ")";
        }
    }
}

