/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.sap.cloud.sdk.cloudplatform.requestheader.RequestHeaderContainer;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceDecorator;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceIsolationMode;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenValidator;
import com.sap.cloud.sdk.cloudplatform.security.OAuth2ServiceProvider;
import com.sap.cloud.sdk.cloudplatform.security.OAuth2TokenServiceCache;
import com.sap.cloud.sdk.cloudplatform.security.ScpCfAuthTokenFacade;
import com.sap.cloud.sdk.cloudplatform.security.exception.AuthTokenAccessException;
import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestFailedException;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.validation.CombiningValidator;
import com.sap.cloud.security.token.validation.ValidationResult;
import com.sap.cloud.security.token.validation.Validator;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlows;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.security.interfaces.RSAPublicKey;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuthTokenDecoder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthTokenDecoder.class);
    private static final String BEARER_PREFIX = "bearer ";
    @Nonnull
    private final OAuth2TokenServiceCache tokenServiceCache;
    @Nonnull
    private final List<CombiningValidator<Token>> tokenValidators;

    AuthTokenDecoder() {
        this(ScpCfAuthTokenFacade.DEFAULT_TOKEN_SERVICE_CACHE, ScpCfAuthTokenFacade.DEFAULT_VALIDATORS);
    }

    public AuthTokenDecoder(@Nullable OAuth2TokenServiceCache serviceCache, @Nullable List<CombiningValidator<Token>> validators) {
        this.tokenServiceCache = serviceCache != null ? serviceCache : OAuth2TokenServiceCache.create();
        this.tokenValidators = validators != null ? validators : ScpCfAuthTokenFacade.loadOauth2Validators();
    }

    @Nonnull
    String getRefreshToken(@Nonnull String encodedJwt, @Nonnull String refreshToken) {
        ResilienceConfiguration resilienceConfiguration = ResilienceConfiguration.of(AuthTokenDecoder.class).isolationMode(ResilienceIsolationMode.NO_ISOLATION).timeLimiterConfiguration(ResilienceConfiguration.TimeLimiterConfiguration.of().timeoutDuration(Duration.ofSeconds(6L))).circuitBreakerConfiguration(ResilienceConfiguration.CircuitBreakerConfiguration.of().waitDuration(Duration.ofSeconds(6L)));
        Supplier tokenSupplier = ResilienceDecorator.decorateSupplier(() -> this.sendRefreshTokenRequestAndParseResponse(encodedJwt, refreshToken), (ResilienceConfiguration)resilienceConfiguration);
        return (String)tokenSupplier.get();
    }

    private String sendRefreshTokenRequestAndParseResponse(@Nonnull String encodedJwt, @Nonnull String refreshToken) {
        DecodedJWT accessToken = JWT.decode((String)encodedJwt);
        XsuaaTokenFlows tokenFlows = OAuth2ServiceProvider.builder().tokenServiceCache(this.tokenServiceCache).staticAccessToken(accessToken).build().getXsuaaTokenFlows();
        return (String)Try.of((CheckedFunction0 & Serializable)() -> tokenFlows.refreshTokenFlow().refreshToken(refreshToken).execute().getAccessToken()).onFailure(e -> log.debug("Failed for access token {} and refresh token {}.", new Object[]{encodedJwt, refreshToken, e})).getOrElseThrow(e -> new TokenRequestFailedException("Refresh JWT request failed", e));
    }

    @Nonnull
    AuthToken decodeAndValidate(@Nonnull String encodedJwt, @Nullable String refreshToken) throws AuthTokenAccessException {
        AuthTokenAccessException preparedException = new AuthTokenAccessException("Failed to verify JWT bearer.");
        Optional<AuthToken> validatedToken = this.tokenValidators.stream().map(tokenValidator -> Try.of((CheckedFunction0 & Serializable)() -> this.validateJwtWithSecurityLibrary(encodedJwt, (Validator<Token>)tokenValidator))).peek(tokenValidation -> tokenValidation.onFailure(arg_0 -> preparedException.addSuppressed(arg_0))).peek(tokenValidation -> tokenValidation.onFailure(e -> log.debug("JWT validation attempt failed.", e))).filter(Try::isSuccess).findFirst().map(Try::get).map(AuthToken::new);
        if (validatedToken.isPresent()) {
            return validatedToken.get();
        }
        if (this.tokenValidators.isEmpty()) {
            log.warn("AuthTokenDecoder was instantiated without a token validator. Falling back to legacy mode for token validation.");
        } else {
            log.warn("Access token validation failed. Falling back to legacy mode. Issuer and JKU properties are not supported.");
        }
        return (AuthToken)this.validateJwtViaLegacyImplementation(encodedJwt, refreshToken).map(AuthToken::new).onFailure(arg_0 -> preparedException.addSuppressed(arg_0)).onFailure(e -> log.debug("JWT validation attempt failed.", e)).getOrElseThrow(t -> preparedException);
    }

    @Nonnull
    Try<AuthToken> decodeAndValidate(@Nonnull RequestHeaderContainer headers) {
        return this.fromAuthorizationHeaders(headers.getHeaderValues("Authorization"));
    }

    @Nonnull
    private Try<AuthToken> fromAuthorizationHeaders(@Nonnull Collection<String> headerValues) {
        if (headerValues.isEmpty()) {
            return Try.failure((Throwable)new AuthTokenAccessException("Failed to decode JWT bearer: no 'Authorization' header present in request."));
        }
        if (headerValues.size() > 1) {
            return Try.failure((Throwable)new AuthTokenAccessException("Failed to decode JWT bearer: multiple 'Authorization' headers present in request."));
        }
        String authorizationValue = headerValues.stream().findFirst().get();
        if (!authorizationValue.toLowerCase(Locale.ENGLISH).startsWith(BEARER_PREFIX)) {
            return Try.failure((Throwable)new AuthTokenAccessException("Failed to decode JWT bearer: no JWT bearer present in 'Authorization' header of request."));
        }
        String tokenValue = authorizationValue.substring(BEARER_PREFIX.length());
        return Try.of((CheckedFunction0 & Serializable)() -> this.decodeAndValidate(tokenValue, null));
    }

    private DecodedJWT validateJwtWithSecurityLibrary(@Nonnull String encodedJwt, @Nonnull Validator<Token> tokenValidator) {
        Token token = Token.create((String)encodedJwt);
        ValidationResult result = tokenValidator.validate((Object)token);
        if (result.isValid()) {
            return JWT.decode((String)encodedJwt);
        }
        throw new AuthTokenAccessException("The token is invalid: " + result.getErrorDescription());
    }

    private Try<DecodedJWT> validateJwtViaLegacyImplementation(@Nonnull String encodedJwt, @Nullable String refreshToken) {
        List<RSAPublicKey> verificationKeys;
        DecodedJWT decodedJWT;
        try {
            decodedJWT = JWT.decode((String)encodedJwt);
            verificationKeys = AuthTokenValidator.getVerificationPublicKeysForJwt(decodedJWT);
        }
        catch (JWTDecodeException | AuthTokenAccessException e) {
            return Try.failure((Throwable)e);
        }
        String targetAlgorithm = decodedJWT.getAlgorithm();
        AuthTokenValidator authTokenValidator = new AuthTokenValidator(targetAlgorithm, verificationKeys);
        Optional<DecodedJWT> verifiedToken = authTokenValidator.verifyToken(encodedJwt);
        if (!verifiedToken.isPresent() && refreshToken != null) {
            String refreshedEncodedJwt = this.getRefreshToken(encodedJwt, refreshToken);
            verifiedToken = authTokenValidator.verifyToken(refreshedEncodedJwt);
        }
        return Try.of(verifiedToken::get);
    }

    @Nonnull
    @Generated
    public OAuth2TokenServiceCache getTokenServiceCache() {
        return this.tokenServiceCache;
    }

    @Nonnull
    @Generated
    public List<CombiningValidator<Token>> getTokenValidators() {
        return this.tokenValidators;
    }
}

