/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.json.JsonSanitizer;
import com.sap.cloud.sdk.cloudplatform.CloudPlatform;
import com.sap.cloud.sdk.cloudplatform.CloudPlatformAccessor;
import com.sap.cloud.sdk.cloudplatform.ScpCfCloudPlatform;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpEntityUtil;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.security.exception.AuthTokenAccessException;
import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestFailedException;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuthTokenValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthTokenValidator.class);
    static Caffeine<Object, Object> tokenCacheBuilder = Caffeine.newBuilder().maximumSize(100000L).expireAfterAccess(5L, TimeUnit.MINUTES);
    static Cache<URI, List<String>> publicTokenKeyCache = tokenCacheBuilder.build();
    private final List<JWTVerifier> verifiers;

    AuthTokenValidator(@Nonnull String tokenAlgorithm, @Nonnull List<RSAPublicKey> verificationKeys) {
        this.verifiers = verificationKeys.stream().map(publicKey -> AuthTokenValidator.tryGetVerifierFromAlgorithm(publicKey, tokenAlgorithm)).filter(Try::isSuccess).map(Try::get).collect(Collectors.toList());
    }

    @Nonnull
    Optional<DecodedJWT> verifyToken(@Nonnull String encodedJwt) {
        return this.verifiers.stream().map(verifier -> Try.of((CheckedFunction0 & Serializable)() -> verifier.verify(encodedJwt))).filter(tryToken -> tryToken.onFailure(e -> log.debug("Failed token verification.", e)).isSuccess()).findFirst().map(Try::get);
    }

    @Nonnull
    static List<RSAPublicKey> getVerificationPublicKeysForJwt(@Nonnull DecodedJWT decodedJwt) throws AuthTokenAccessException {
        JsonObject xsuaaServiceCredentials = (JsonObject)Try.of((CheckedFunction0 & Serializable)() -> AuthTokenValidator.getCloudPlatform().getXsuaaServiceCredentials(decodedJwt)).getOrElseThrow(e -> new AuthTokenAccessException("Failed to verify JWT bearer.", e));
        List<String> publicKeysRaw = AuthTokenValidator.getPublicKeysFromCredentials(xsuaaServiceCredentials);
        return publicKeysRaw.stream().map(keyRaw -> keyRaw.replaceAll("\\n", "")).map(keyRaw -> keyRaw.replace("-----BEGIN PUBLIC KEY-----", "")).map(keyRaw -> keyRaw.replace("-----END PUBLIC KEY-----", "")).map(keyRefined -> Try.of((CheckedFunction0 & Serializable)() -> new X509EncodedKeySpec(Base64.getDecoder().decode((String)keyRefined)))).map(trySpec -> trySpec.mapTry((CheckedFunction1 & Serializable)keySpec -> KeyFactory.getInstance("RSA").generatePublic((KeySpec)keySpec))).map(tryKey -> tryKey.mapTry(RSAPublicKey.class::cast)).filter(tryKey -> tryKey.onFailure(e -> log.warn("Failed to parse public key.", e)).isSuccess()).map(Try::get).collect(Collectors.toList());
    }

    @Nonnull
    private static Try<JWTVerifier> tryGetVerifierFromAlgorithm(@Nonnull RSAPublicKey verificationKey, @Nullable String algorithmIdentifier) {
        Algorithm algorithm;
        if (algorithmIdentifier == null) {
            return Try.failure((Throwable)new AuthTokenAccessException("Failed to verify JWT bearer: no algorithm specified in token header."));
        }
        switch (algorithmIdentifier) {
            case "RS256": {
                algorithm = Algorithm.RSA256((RSAPublicKey)verificationKey, null);
                break;
            }
            case "RS384": {
                algorithm = Algorithm.RSA384((RSAPublicKey)verificationKey, null);
                break;
            }
            case "RS512": {
                algorithm = Algorithm.RSA512((RSAPublicKey)verificationKey, null);
                break;
            }
            default: {
                return Try.failure((Throwable)new AuthTokenAccessException("Failed to verify JWT bearer: algorithm '" + algorithmIdentifier + "' not supported."));
            }
        }
        return Try.of((CheckedFunction0 & Serializable)() -> JWT.require((Algorithm)algorithm).build()).onFailure(e -> log.debug("Failed to instantiate token validator from algorithm.", e));
    }

    private static ScpCfCloudPlatform getCloudPlatform() {
        CloudPlatform cloudPlatform = CloudPlatformAccessor.getCloudPlatform();
        if (!(cloudPlatform instanceof ScpCfCloudPlatform)) {
            throw new ShouldNotHappenException("The current Cloud platform is not an instance of " + ScpCfCloudPlatform.class.getSimpleName() + ". Please make sure to specify a dependency to com.sap.cloud.sdk.cloudplatform:core-scp-cf.");
        }
        return (ScpCfCloudPlatform)cloudPlatform;
    }

    private static List<String> getPublicKeysFromCredentials(JsonObject xsuaaServiceCredentials) throws AuthTokenAccessException {
        ArrayList combinedResult = Lists.newArrayList();
        Try remoteKeys = Try.of((CheckedFunction0 & Serializable)() -> AuthTokenValidator.getCachedRemotePublicKeys(xsuaaServiceCredentials));
        remoteKeys.onFailure(e -> log.warn("Failed to load remote public keys.", e)).onSuccess(combinedResult::addAll);
        Try localKey = Try.of((CheckedFunction0 & Serializable)() -> AuthTokenValidator.getLocalPublicKey(xsuaaServiceCredentials));
        localKey.onFailure(e -> log.warn("Failed to load local public key.", e)).onSuccess(combinedResult::add);
        if (combinedResult.isEmpty()) {
            throw new AuthTokenAccessException("Unable to resolve any public keys from local environment or remote endpoints.");
        }
        return combinedResult;
    }

    private static String getLocalPublicKey(JsonObject xsuaaServiceCredentials) throws AuthTokenAccessException {
        return (String)Option.of((Object)xsuaaServiceCredentials.get("verificationkey")).map(JsonElement::getAsString).getOrElseThrow(() -> new AuthTokenAccessException("Failed to verify JWT bearer: no verification key found in XSUAA service credentials."));
    }

    private static List<String> getCachedRemotePublicKeys(JsonObject xsuaaServiceCredentials) throws IOException {
        String xsuaaUrl = xsuaaServiceCredentials.get("url").getAsString();
        URI uri = URI.create((xsuaaUrl.endsWith("/") ? xsuaaUrl : xsuaaUrl + "/") + "token_keys");
        List<String> cachedKeys = (List<String>)publicTokenKeyCache.getIfPresent((Object)uri);
        if (cachedKeys == null) {
            cachedKeys = AuthTokenValidator.getRemotePublicKeysFromUri(uri);
            publicTokenKeyCache.put((Object)uri, cachedKeys);
        }
        return cachedKeys;
    }

    private static List<String> getRemotePublicKeysFromUri(URI uri) throws IOException {
        HttpGet tokenRequest = new HttpGet(uri);
        tokenRequest.setHeader("Accept", ContentType.APPLICATION_JSON.toString());
        HttpClient httpClient = HttpClientAccessor.getHttpClientFactory().createHttpClient();
        HttpResponse response = httpClient.execute((HttpUriRequest)tokenRequest);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 400 && statusCode <= 599) {
            throw new TokenRequestFailedException("Refresh JWT request failed with status code " + statusCode + ": " + response.getStatusLine().getReasonPhrase());
        }
        String responseBody = HttpEntityUtil.getResponseBody((HttpResponse)response);
        JsonObject responseJson = JsonParser.parseString((String)JsonSanitizer.sanitize((String)responseBody)).getAsJsonObject();
        JsonArray keys = responseJson.getAsJsonArray("keys");
        return Streams.stream((Iterable)keys).map(AuthTokenValidator::tryParseRemotePublicKey).filter(Try::isSuccess).map(Try::get).collect(Collectors.toList());
    }

    private static Try<String> tryParseRemotePublicKey(@Nullable JsonElement keyEntry) {
        if (keyEntry == null) {
            return Try.failure((Throwable)new IOException("Detected missing key value."));
        }
        return Try.of((CheckedFunction0 & Serializable)() -> keyEntry.getAsJsonObject().getAsJsonPrimitive("value").getAsString()).onFailure(e -> log.debug("Failed to read value for public key.", e));
    }
}

