/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.validation.ValidationResult;
import com.sap.cloud.security.token.validation.ValidationResults;
import com.sap.cloud.security.token.validation.Validator;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
class CustomJwtIssuerValidator
implements Validator<Token> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomJwtIssuerValidator.class);
    private static final Pattern HAS_PROTOCOL_PATTERN = Pattern.compile("^\\w+://");
    private static final Predicate<String> HAS_PROTOCOL = uri -> HAS_PROTOCOL_PATTERN.matcher((CharSequence)uri).find();
    @Nonnull
    private final List<String> domains;

    public CustomJwtIssuerValidator(@Nonnull OAuth2ServiceConfiguration configuration) {
        this.domains = configuration.getDomains();
        if (this.domains == null || this.domains.isEmpty()) {
            throw new IllegalArgumentException("JwtIssuerValidator requires a domain(s).");
        }
    }

    public ValidationResult validate(Token token) {
        if (this.checkIssuerInDomains(token.getClaimAsString("iss")) || this.checkIssuerInDomains(token.getClaimAsString("ias_iss"))) {
            return ValidationResults.createValid();
        }
        return ValidationResults.createInvalid((String)"Issuer is not trusted because it doesn't match any of these domains '{}' of the identity provider.", (Object[])new Object[]{this.domains});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean checkIssuerInDomains(@Nullable String issuer) {
        if (issuer == null) {
            return false;
        }
        String host = CustomJwtIssuerValidator.extractHost(issuer);
        if (host == null) return false;
        if (!this.domains.stream().anyMatch(host::endsWith)) return false;
        return true;
    }

    @Nullable
    static String extractHost(String uri) {
        String httpUri = HAS_PROTOCOL.test(uri) ? uri : "https://" + uri;
        return (String)Try.of((CheckedFunction0 & Serializable)() -> new URI(httpUri).getHost()).onFailure(e -> log.warn("Invalid URI: {}", (Object)uri, e)).getOrNull();
    }
}

