/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.common.collect.Sets;
import com.sap.cloud.sdk.cloudplatform.ScpCfCloudPlatform;
import com.sap.cloud.sdk.cloudplatform.requestheader.RequestHeaderAccessor;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceDecorator;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceIsolationMode;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenDecoder;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenRequest;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenThreadContextListener;
import com.sap.cloud.sdk.cloudplatform.security.CustomJwtIssuerValidator;
import com.sap.cloud.sdk.cloudplatform.security.ExecutableAuthTokenFacade;
import com.sap.cloud.sdk.cloudplatform.security.K8sWorkarounds;
import com.sap.cloud.sdk.cloudplatform.security.OAuth2ServiceProvider;
import com.sap.cloud.sdk.cloudplatform.security.OAuth2TokenServiceCache;
import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestDeniedException;
import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestFailedException;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContext;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextAccessor;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextExecutor;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextListener;
import com.sap.cloud.sdk.cloudplatform.thread.exception.ThreadContextExecutionException;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.config.cf.CFConstants;
import com.sap.cloud.security.config.cf.CFEnvironment;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.validation.CombiningValidator;
import com.sap.cloud.security.token.validation.validators.JwtValidatorBuilder;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlows;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScpCfAuthTokenFacade
extends ExecutableAuthTokenFacade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScpCfAuthTokenFacade.class);
    private static final String MESSAGE_INVALID_REFRESH_TOKEN = "Failed to get access token: no valid refresh token found in response of user token flow. Please make sure to correctly bind your application to an OAuth2 compatible service instance.";
    @Nonnull
    static final OAuth2TokenServiceCache DEFAULT_TOKEN_SERVICE_CACHE = OAuth2TokenServiceCache.create();
    @Nonnull
    static final List<CombiningValidator<Token>> DEFAULT_VALIDATORS = ScpCfAuthTokenFacade.loadOauth2Validators();
    @Nonnull
    private final OAuth2TokenServiceCache tokenServiceCache;
    @Nonnull
    private final List<CombiningValidator<Token>> tokenValidators;

    public ScpCfAuthTokenFacade() {
        this(DEFAULT_TOKEN_SERVICE_CACHE, DEFAULT_VALIDATORS);
    }

    public ScpCfAuthTokenFacade(@Nonnull OAuth2TokenService tokenService, @Nullable OAuth2ServiceConfiguration oauth2Configuration) {
        this(OAuth2TokenServiceCache.single(tokenService), (List)Option.of((Object)oauth2Configuration).onEmpty(() -> log.warn("AuthTokenFacade instantiated without an OAuth2 configuration.")).map(ScpCfAuthTokenFacade::getJwtValidator).map(Collections::singletonList).getOrElse(Collections::emptyList));
    }

    @Nonnull
    public Try<AuthToken> tryGetCurrentToken() {
        ThreadContext currentContext = ThreadContextAccessor.getCurrentContextOrNull();
        if (currentContext != null && currentContext.containsProperty(AuthTokenThreadContextListener.PROPERTY_AUTH_TOKEN)) {
            return currentContext.getPropertyValue(AuthTokenThreadContextListener.PROPERTY_AUTH_TOKEN);
        }
        return RequestHeaderAccessor.tryGetHeaderContainer().flatMap(this.getAuthTokenDecoder()::decodeAndValidate);
    }

    @Nonnull
    public Try<AuthToken> tryGetXsuaaServiceToken() {
        AuthTokenDecoder authTokenDecoder = this.getAuthTokenDecoder();
        return Try.of((CheckedFunction0 & Serializable)() -> new AuthTokenRequest(authTokenDecoder, this.tokenServiceCache).getXsuaaServiceToken());
    }

    @Nonnull
    public Future<String> getRefreshToken(@Nonnull DecodedJWT jwt) {
        ResilienceConfiguration resilienceConfiguration = ResilienceConfiguration.of(ScpCfAuthTokenFacade.class).isolationMode(ResilienceIsolationMode.NO_ISOLATION).timeLimiterConfiguration(ResilienceConfiguration.TimeLimiterConfiguration.of().timeoutDuration(Duration.ofSeconds(6L))).circuitBreakerConfiguration(ResilienceConfiguration.CircuitBreakerConfiguration.of().waitDuration(Duration.ofSeconds(6L)));
        Callable tokenCallable = ResilienceDecorator.decorateCallable(() -> this.sendTokenRequestAndParseResponse(jwt), (ResilienceConfiguration)resilienceConfiguration);
        FutureTask<String> tokenFuture = new FutureTask<String>(tokenCallable);
        tokenFuture.run();
        return tokenFuture;
    }

    @Nonnull
    private String sendTokenRequestAndParseResponse(@Nonnull DecodedJWT jwt) throws TokenRequestDeniedException, TokenRequestFailedException {
        String authorizationBearer = jwt.getToken();
        XsuaaTokenFlows tokenFlows = OAuth2ServiceProvider.builder().tokenServiceCache(this.tokenServiceCache).staticAccessToken(jwt).build().getXsuaaTokenFlows();
        return (String)Try.of((CheckedFunction0 & Serializable)() -> tokenFlows.userTokenFlow().token(authorizationBearer).execute().getRefreshToken()).onFailure(e -> log.debug("User token request failed for auth token {}.", (Object)authorizationBearer, e)).filter(Objects::nonNull, () -> new TokenRequestFailedException(MESSAGE_INVALID_REFRESH_TOKEN)).getOrElseThrow(e -> new TokenRequestFailedException("Refresh JWT request failed", e));
    }

    @Nonnull
    static CombiningValidator<Token> getJwtValidator(@Nonnull OAuth2ServiceConfiguration configuration) {
        CombiningValidator result = JwtValidatorBuilder.getInstance((OAuth2ServiceConfiguration)configuration).build();
        String workaroundClass = "com.sap.cloud.security.token.validation.validators.JwtIssuerValidator";
        if (result.getValidators().removeIf(validator -> "com.sap.cloud.security.token.validation.validators.JwtIssuerValidator".equals(validator.getClass().getName()))) {
            result.getValidators().add(new CustomJwtIssuerValidator(configuration));
        }
        return result;
    }

    @Nonnull
    static List<CombiningValidator<Token>> loadOauth2Validators() {
        List<OAuth2ServiceConfiguration> oauth2Configurations = ScpCfAuthTokenFacade.loadOauth2ServiceConfigurations();
        if (oauth2Configurations.isEmpty()) {
            log.debug("No OAuth2 validators were registered since no configuration could be loaded.");
        }
        return oauth2Configurations.stream().map(conf -> Try.of((CheckedFunction0 & Serializable)() -> ScpCfAuthTokenFacade.getJwtValidator(conf))).filter(validator -> validator.onFailure(e -> log.warn("Failed to load validator.", e)).isSuccess()).map(Try::get).collect(Collectors.toList());
    }

    @Nonnull
    private static List<OAuth2ServiceConfiguration> loadOauth2ServiceConfigurations() {
        Try environment = Try.of((CheckedFunction0 & Serializable)() -> {
            ScpCfCloudPlatform platform = ScpCfCloudPlatform.getInstanceOrThrow();
            return CFEnvironment.getInstance(k -> K8sWorkarounds.getEnvironmentVariable(platform, k), System::getProperty);
        });
        if (environment.isSuccess()) {
            List<OAuth2ServiceConfiguration> configurations = Sets.cartesianProduct((Set[])new Set[]{EnumSet.allOf(Service.class), EnumSet.allOf(CFConstants.Plan.class)}).stream().map(p -> ((CFEnvironment)environment.get()).loadForServicePlan((Service)p.get(0), (CFConstants.Plan)p.get(1))).filter(Objects::nonNull).peek(c -> log.debug("Found {} service binding with plan {}, client id {} and application id {}.", new Object[]{c.getService().getCFName(), c.getProperty("plan"), c.getClientId(), c.getProperty("xsappname")})).collect(Collectors.toList());
            if (configurations.isEmpty()) {
                log.warn("Could not find any OAuth2 based service bindings.");
            }
            return configurations;
        }
        log.error("Failed to read environment data for OAuth2 based configurations.", environment.getCause());
        return Collections.emptyList();
    }

    AuthTokenDecoder getAuthTokenDecoder() {
        return new AuthTokenDecoder(this.tokenServiceCache, this.tokenValidators);
    }

    @Nullable
    protected <T> T executeWithAuthToken(@Nonnull AuthToken authToken, @Nonnull Callable<T> callable) throws ThreadContextExecutionException {
        return (T)ThreadContextExecutor.fromCurrentOrNewContext().withListeners(new ThreadContextListener[]{new AuthTokenThreadContextListener(authToken)}).execute(callable);
    }

    @Generated
    ScpCfAuthTokenFacade(@Nonnull OAuth2TokenServiceCache tokenServiceCache, @Nonnull List<CombiningValidator<Token>> tokenValidators) {
        if (tokenServiceCache == null) {
            throw new NullPointerException("tokenServiceCache is marked non-null but is null");
        }
        if (tokenValidators == null) {
            throw new NullPointerException("tokenValidators is marked non-null but is null");
        }
        this.tokenServiceCache = tokenServiceCache;
        this.tokenValidators = tokenValidators;
    }
}

