/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.principal;

import com.auth0.jwt.interfaces.Payload;
import com.google.common.collect.Sets;
import com.sap.cloud.sdk.cloudplatform.security.Authorization;
import com.sap.cloud.sdk.cloudplatform.security.Scope;
import com.sap.cloud.sdk.cloudplatform.security.principal.DefaultLocalScopePrefixProvider;
import com.sap.cloud.sdk.cloudplatform.security.principal.LocalScopePrefixProvider;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalScopePrefixExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalScopePrefixExtractor.class);
    static final String JWT_SCOPE_CLAIM = "scope";
    @Nonnull
    private final LocalScopePrefixProvider localScopePrefixProvider;

    public LocalScopePrefixExtractor(@Nullable LocalScopePrefixProvider localScopePrefixProvider) {
        this.localScopePrefixProvider = localScopePrefixProvider != null ? localScopePrefixProvider : new DefaultLocalScopePrefixProvider();
    }

    @Nonnull
    public Try<Set<Authorization>> getAuthorizations(@Nonnull Payload jwt) {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            HashSet authorizations = Sets.newHashSet();
            List scopeNames = jwt.getClaim(JWT_SCOPE_CLAIM).asList(String.class);
            String localScopePrefixWithDot = (String)this.localScopePrefixProvider.getLocalScopePrefix().map(prefix -> prefix.endsWith(".") ? prefix : prefix + ".").getOrNull();
            if (scopeNames != null) {
                for (String scopeName : scopeNames) {
                    if (localScopePrefixWithDot != null && scopeName.startsWith(localScopePrefixWithDot)) {
                        log.debug("Adding local scope '{}'.", (Object)scopeName);
                        authorizations.add(new Scope(scopeName.substring(localScopePrefixWithDot.length())));
                        continue;
                    }
                    log.debug("Skipping non-local scope '{}'.", (Object)scopeName);
                }
            } else {
                log.debug("Skipping reading of user authorizations: cannot find field '{}' in authorization token.", (Object)JWT_SCOPE_CLAIM);
            }
            return authorizations;
        });
    }
}

