/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.principal;

import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.sap.cloud.sdk.cloudplatform.security.Audience;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenAccessor;
import com.sap.cloud.sdk.cloudplatform.security.Authorization;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalAttribute;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalExtractor;
import com.sap.cloud.sdk.cloudplatform.security.principal.ScpCfPrincipal;
import com.sap.cloud.sdk.cloudplatform.security.principal.exception.PrincipalAccessException;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

class OidcAuthTokenPrincipalExtractor
implements PrincipalExtractor {
    private static final String JWT_USER_UUID_CLAIM = "user_uuid";
    private static final String JWT_AUDIENCES_CLAIM = "aud";
    private static final Set<Authorization> EMPTY_AUTHORIZATIONS = Collections.emptySet();
    private static final Map<String, PrincipalAttribute> EMPTY_ATTRIBUTES = Collections.emptyMap();

    OidcAuthTokenPrincipalExtractor() {
    }

    @Override
    @Nonnull
    public Try<Principal> tryGetCurrentPrincipal() {
        Try jwtTry = AuthTokenAccessor.tryGetCurrentToken().map(AuthToken::getJwt);
        if (jwtTry.isFailure()) {
            return Try.failure((Throwable)jwtTry.getCause());
        }
        DecodedJWT jwt = (DecodedJWT)jwtTry.get();
        Try<String> principalIdTry = this.tryGetPrincipalId(jwt);
        if (principalIdTry.isFailure()) {
            return Try.failure((Throwable)principalIdTry.getCause());
        }
        String principalId = (String)principalIdTry.get();
        Set audiences = (Set)this.tryGetAudiences(jwt).getOrElse(Collections::emptySet);
        return Try.of((CheckedFunction0 & Serializable)() -> new ScpCfPrincipal(principalId, EMPTY_AUTHORIZATIONS, EMPTY_AUTHORIZATIONS, audiences, EMPTY_ATTRIBUTES));
    }

    private Try<String> tryGetPrincipalId(@Nonnull DecodedJWT jwt) {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            Claim userUuidClaim = jwt.getClaim(JWT_USER_UUID_CLAIM);
            if (userUuidClaim.isMissing() || userUuidClaim.isNull()) {
                throw new PrincipalAccessException("The current JWT does not contain the IAS user uuid.");
            }
            return userUuidClaim.asString();
        });
    }

    private Try<Set<Audience>> tryGetAudiences(@Nonnull DecodedJWT jwt) {
        return Try.of((CheckedFunction0 & Serializable)() -> ((List)Option.of((Object)jwt.getClaim(JWT_AUDIENCES_CLAIM).asList(String.class)).get()).stream().map(Audience::new).collect(Collectors.toSet()));
    }
}

