/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestFailedException;

import io.vavr.control.Try;
import lombok.extern.slf4j.Slf4j;

/**
 * Class encapsulating the request to receive a JWT from an XSUAA service.
 */
@Slf4j
@Deprecated
class AuthTokenRequest
{
    private final AuthTokenDecoder decoder;
    private final OAuth2TokenServiceCache tokenServiceCache;

    /**
     * Creates a request with the given decoder.
     *
     * @param decoder
     *            The decoder to decode the JWT from encoded String to decoded {@link AuthToken}. If null a new
     *            {@link AuthTokenDecoder} is used.
     */
    AuthTokenRequest( @Nullable final AuthTokenDecoder decoder, @Nullable final OAuth2TokenServiceCache serviceCache )
    {
        this.tokenServiceCache = serviceCache == null ? OAuth2TokenServiceCache.create() : serviceCache;
        this.decoder = decoder == null ? new AuthTokenDecoderDefault() : decoder;
    }

    /**
     * Creates a request with a {@link AuthTokenDecoder} to validate the received JWT.
     */
    AuthTokenRequest()
    {
        this(null, null);
    }

    /**
     * Retrieves a validated authentication token from the bound XSUAA instance.
     *
     * @return An authentication token from the XSUAA instance.
     *
     * @throws TokenRequestFailedException
     *             If no XSUAA instance was bound or the communication with the service failed.
     */
    @Nonnull
    @Deprecated
    AuthToken getXsuaaServiceToken()
        throws TokenRequestFailedException
    {
        final String accessToken =
            Try
                .of(
                    () -> OAuth2ServiceProvider
                        .builder()
                        .tokenServiceCache(tokenServiceCache)
                        .build()
                        .getXsuaaTokenFlows()
                        .clientCredentialsTokenFlow()
                        .execute()
                        .getAccessToken())
                .getOrElseThrow(TokenRequestFailedException::new);

        return decoder.decode(accessToken);
    }
}
