/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlows;

/**
 * Wrapper type for XSUAA security related features.
 *
 * @deprecated Please directly use the token client library instead.
 */
@FunctionalInterface
@Deprecated
public interface OAuth2ServiceProvider
{
    /**
     * Instantiate a new builder.
     *
     * @return A new builder instance.
     */
    @Nonnull
    static OAuth2ServiceProviderBuilder builder()
    {
        return DefaultOAuth2ServiceProvider.builder();
    }

    /**
     * Shortcut method to instantiate an XSUAA request builder from the security library.
     *
     * @return A new instance of {@link XsuaaTokenFlows}
     */
    @Nonnull
    XsuaaTokenFlows getXsuaaTokenFlows();

    /**
     * Builder type to customize OAuth2 service specific settings.
     */
    interface OAuth2ServiceProviderBuilder
    {
        /**
         * Finilize builder, instantiate the object.
         *
         * @return A new instance of {@link OAuth2ServiceProvider}.
         */
        @Nonnull
        OAuth2ServiceProvider build();

        /**
         * Set a static credentials object. The client identity will not be derived automatically any longer.
         *
         * @param credentials
         *            The {@link Credentials} object.
         * @return The same builder.
         */
        @Nonnull
        OAuth2ServiceProviderBuilder staticCredentials( @Nullable final Credentials credentials );

        /**
         * Set custom OAuth service settings. Use this method to customize service endpoints.
         *
         * @param serverSettings
         *            The {@link OAuth2ServiceSettings} object, containing base url and OAuth related paths.
         * @return The same builder.
         */
        @Nonnull
        OAuth2ServiceProviderBuilder serviceSettings( @Nullable final OAuth2ServiceSettings serverSettings );

        /**
         * Set a static access token. The current user access token will no longer be used to derive service binding.
         *
         * @param accessToken
         *            The {@link DecodedJWT} object.
         * @return The same builder.
         */
        @Nonnull
        OAuth2ServiceProviderBuilder staticAccessToken( @Nullable final DecodedJWT accessToken );

        /**
         * Set a static platform object. When using this method, the platform will no longer be derived automatically.
         *
         * @param platform
         *            The {@link com.sap.cloud.sdk.cloudplatform.CloudPlatform} object.
         * @return The same builder.
         */
        @Nonnull
        OAuth2ServiceProviderBuilder platform( @Nullable final com.sap.cloud.sdk.cloudplatform.CloudPlatform platform );

        /**
         * Set a token service cache. If this property remains null, then a new cache will be instantiated by default.
         *
         * @param cache
         *            The {@link OAuth2TokenServiceCache} object.
         * @return The same builder.
         */
        @Nonnull
        OAuth2ServiceProviderBuilder tokenServiceCache( @Nullable final OAuth2TokenServiceCache cache );
    }
}
