/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servletjakarta;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.requestheader.DefaultRequestHeaderContainer;
import com.sap.cloud.sdk.cloudplatform.requestheader.RequestHeaderContainer;
import com.sap.cloud.sdk.cloudplatform.requestheader.RequestHeaderThreadContextListener;
import com.sap.cloud.sdk.cloudplatform.thread.DefaultThreadContext;
import com.sap.cloud.sdk.cloudplatform.thread.Property;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContext;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextExecutor;
import io.vavr.control.Option;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebFilter(filterName="RequestAccessorFilter", urlPatterns={"/*"})
@Beta
public class RequestAccessorFilter
implements Filter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestAccessorFilter.class);

    public void init(@Nonnull FilterConfig filterConfig) {
    }

    public void doFilter(@Nonnull ServletRequest request, @Nonnull ServletResponse response, @Nonnull FilterChain filterChain) {
        if (request instanceof HttpServletRequest) {
            try {
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                DefaultThreadContext threadContext = new DefaultThreadContext();
                this.storeServletProperties(httpRequest, (ThreadContext)threadContext);
                ThreadContextExecutor.using((ThreadContext)threadContext).execute(() -> filterChain.doFilter(request, response));
            }
            catch (Throwable t) {
                log.warn("Unexpected servlet filter exception: " + t.getMessage(), t);
                throw new ShouldNotHappenException(t);
            }
        } else if (log.isWarnEnabled()) {
            log.warn("Failed to initialize " + ThreadContext.class.getSimpleName() + ": request not of type " + HttpServletRequest.class.getName() + ".");
        }
    }

    private void storeServletProperties(@Nonnull HttpServletRequest servlet, @Nonnull ThreadContext threadContext) {
        threadContext.setPropertyIfAbsent(RequestHeaderThreadContextListener.PROPERTY_REQUEST_HEADERS, Property.decorateCallable(() -> RequestAccessorFilter.extractHeaders(servlet)));
    }

    @Nonnull
    private static RequestHeaderContainer extractHeaders(@Nonnull HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames == null) {
            return RequestHeaderContainer.EMPTY;
        }
        HashMap headers = new HashMap();
        while (headerNames.hasMoreElements()) {
            Option headerName = Option.of((Object)((String)headerNames.nextElement()));
            headerName.map(arg_0 -> ((HttpServletRequest)request).getHeaders(arg_0)).filter(Objects::nonNull).peek(values -> headers.put((String)headerName.get(), Collections.list(values)));
        }
        return DefaultRequestHeaderContainer.fromMultiValueMap(headers);
    }

    public void destroy() {
    }
}

