/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet;

import java.util.Collections;
import java.util.List;
import java.util.Locale;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;

/**
 * Facade for accessing {@link Locale} information.
 */
public class DefaultLocaleFacade implements LocaleFacade
{
    /**
     * {@inheritDoc}
     */
    @Override
    @Nonnull
    public Locale getCurrentLocale()
    {
        @Nullable
        final HttpServletRequest request = RequestAccessor.tryGetCurrentRequest().getOrNull();

        if( request == null ) {
            return Locale.getDefault();
        }

        return request.getLocale();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    @Nonnull
    public List<Locale> getCurrentLocales()
    {
        @Nullable
        final HttpServletRequest request = RequestAccessor.tryGetCurrentRequest().getOrNull();

        if( request == null ) {
            return Collections.singletonList(Locale.getDefault());
        }

        return Collections.list(request.getLocales());
    }
}
