/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.exception;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.cloudplatform.servlet.response.NotImplementedResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;
import com.sap.cloud.sdk.cloudplatform.servlet.response.WithErrorResponse;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * Thrown when trying to use a feature toggle that is not enabled.
 */
@NoArgsConstructor
@Data
@EqualsAndHashCode( callSuper = false )
public class NotImplementedException extends RuntimeException implements WithErrorResponse
{
    private static final long serialVersionUID = -4029333728747367984L;

    /**
     * Exception constructor.
     * 
     * @param message
     *            The exception message.
     */
    public NotImplementedException( @Nullable final String message )
    {
        super(message);
    }

    /**
     * Exception constructor.
     * 
     * @param cause
     *            The exception cause.
     */
    public NotImplementedException( @Nullable final Throwable cause )
    {
        super(cause);
    }

    /**
     * Exception constructor.
     * 
     * @param message
     *            The exception message.
     * @param cause
     *            The exception cause.
     */
    public NotImplementedException( @Nullable final String message, @Nullable final Throwable cause )
    {
        super(message, cause);
    }

    /**
     * {@inheritDoc}
     */
    @Nonnull
    @Override
    public ResponseWithErrorCode getErrorResponse()
    {
        return new NotImplementedResponse();
    }
}
