/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.exception;

import javax.annotation.Nullable;

import lombok.RequiredArgsConstructor;

/**
 * Thrown if the request cannot be accessed.
 */
@RequiredArgsConstructor
public class RequestAccessException extends RuntimeException
{
    private static final long serialVersionUID = 1405843603105616280L;

    /**
     * Exception constructor.
     * 
     * @param message
     *            The exception message.
     */
    public RequestAccessException( @Nullable final String message )
    {
        super(message);
    }

    /**
     * Exception constructor.
     * 
     * @param cause
     *            The exception cause.
     */
    public RequestAccessException( @Nullable final Throwable cause )
    {
        super(cause);
    }

    /**
     * Exception constructor.
     * 
     * @param message
     *            The exception message.
     * @param cause
     *            The exception cause.
     */
    public RequestAccessException( @Nullable final String message, @Nullable final Throwable cause )
    {
        super(message, cause);
    }
}
