/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import java.util.Set;

import javax.annotation.Nullable;

import org.apache.http.HttpStatus;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Sets;
import com.google.gson.annotations.Expose;

import lombok.Getter;

/**
 * Access Denied Response.
 */
public class AccessDeniedResponse extends ResponseWithErrorCode
{
    @Nullable
    @Getter
    @Expose
    @JsonProperty
    private final String user;

    @Nullable
    @Getter
    @Expose
    @JsonProperty
    private final Set<String> missingAuthorizations;

    /**
     * Default constructor.
     */
    public AccessDeniedResponse()
    {
        this(null, null, null);
    }

    /**
     * Detailed constructor.
     * 
     * @param user
     *            The optional user to which access has been denied.
     * @param missingAuthorizations
     *            The optional set of missing authorizations.
     * @param description
     *            The optional error description.
     */
    public AccessDeniedResponse(
        @Nullable final String user,
        @Nullable final Iterable<String> missingAuthorizations,
        @Nullable final String description )
    {
        super(HttpStatus.SC_FORBIDDEN, "access_denied", description);

        this.user = user;

        if( missingAuthorizations != null ) {
            this.missingAuthorizations = Sets.newHashSet(missingAuthorizations);
        } else {
            this.missingAuthorizations = null;
        }
    }
}
