/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import javax.annotation.Nullable;

import org.apache.http.HttpStatus;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.Expose;

import lombok.Getter;

/**
 * Entity Not Found.
 */
public class EntityNotFoundResponse extends ResponseWithErrorCode
{
    @Getter
    @Expose
    @JsonProperty
    private final String entity;

    /**
     * Default constructor.
     */
    public EntityNotFoundResponse()
    {
        this(null, null);
    }

    /**
     * Constructor with entity reference.
     * 
     * @param entity
     *            The optional entity String representation.
     * @param description
     *            The optional error description.
     */
    public EntityNotFoundResponse( @Nullable final String entity, @Nullable final String description )
    {
        super(HttpStatus.SC_NOT_FOUND, "entity_not_found", description);
        this.entity = entity;
    }
}
