/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import javax.annotation.Nullable;

import org.apache.http.HttpStatus;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.Expose;

/**
 * Feature Not Enabled.
 */
public class FeatureNotEnabledResponse extends ResponseWithErrorCode
{
    @Nullable
    @Expose
    @JsonProperty
    private String feature;

    private static final String DEFAULT_DESCRIPTION = "This feature is not enabled.";

    /**
     * Default constructor.
     */
    public FeatureNotEnabledResponse()
    {
        this(DEFAULT_DESCRIPTION);
    }

    /**
     * Constructor with description.
     * 
     * @param description
     *            The optional error description.
     */
    public FeatureNotEnabledResponse( @Nullable final String description )
    {
        super(HttpStatus.SC_UNPROCESSABLE_ENTITY, "feature_not_enabled", description);
        feature = null;
    }

    /**
     * Constructor missing feature reference.
     * 
     * @param feature
     *            The feature name.
     * @param supportComponent
     *            The component to create support tickets for.
     */
    public FeatureNotEnabledResponse( @Nullable final String feature, @Nullable final String supportComponent )
    {
        this(
            supportComponent != null
                ? String.format(
                    "%s Please create a customer ticket for SAP under the component %s",
                    DEFAULT_DESCRIPTION,
                    supportComponent)
                : null);

        this.feature = feature;
    }
}
