/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import javax.annotation.Nullable;

import org.apache.http.HttpStatus;

/**
 * Forbidden Operation.
 */
public class ForbiddenOperationResponse extends ResponseWithErrorCode
{
    /**
     * Default constructor.
     */
    public ForbiddenOperationResponse()
    {
        this(null);
    }

    /**
     * Constructor with description.
     * 
     * @param description
     *            The optional error description.
     */
    public ForbiddenOperationResponse( @Nullable final String description )
    {
        super(HttpStatus.SC_FORBIDDEN, "operation_forbidden", description);
    }
}
