/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import javax.annotation.Nullable;

import org.apache.http.HttpStatus;

/**
 * Format Not Recognized.
 */
public class FormatNotRecognizedResponse extends ResponseWithErrorCode
{
    /**
     * Default constructor.
     */
    public FormatNotRecognizedResponse()
    {
        this(null);
    }

    /**
     * Constructor with description.
     * 
     * @param description
     *            The optional error description.
     */
    public FormatNotRecognizedResponse( @Nullable final String description )
    {
        super(HttpStatus.SC_BAD_REQUEST, "format_not_recognized", description);
    }
}
