/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import java.util.Collection;

import javax.annotation.Nullable;

import org.apache.http.HttpStatus;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.Expose;

/**
 * Mandatory Fields Missing.
 */
public class MandatoryFieldsMissingResponse extends ResponseWithErrorCode
{
    @Nullable
    @Expose
    @JsonProperty
    private final Collection<String> fields;

    /**
     * Get the collection of missing mandatory fields.
     * 
     * @return The missing fields.
     */
    @Nullable
    @JsonIgnore
    public Collection<String> getFields()
    {
        return fields;
    }

    /**
     * Default constructor.
     */
    public MandatoryFieldsMissingResponse()
    {
        this(null, null);
    }

    /**
     * Constructor with field reference.
     * 
     * @param fields
     *            The optional set of mandatory parameters being missed.
     * @param description
     *            The optional error description.
     */
    public MandatoryFieldsMissingResponse(
        @Nullable final Collection<String> fields,
        @Nullable final String description )
    {
        super(HttpStatus.SC_BAD_REQUEST, "mandatory_fields_missing", description);
        this.fields = fields;
    }
}
