/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.HttpStatus;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.Expose;

import io.vavr.control.Option;

/**
 * Missing Parameter.
 */
public class MissingParameterResponse extends ResponseWithErrorCode
{
    @Nullable
    @Expose
    @JsonProperty
    private final String parameter;

    /**
     * Get the missing parameter.
     * 
     * @return The missing parameter.
     */
    @JsonIgnore
    @Nonnull
    public Option<String> getParameter()
    {
        return Option.of(parameter);
    }

    /**
     * Default constructor.
     */
    public MissingParameterResponse()
    {
        this(null, null);
    }

    /**
     * Constructor with parameter reference.
     * 
     * @param parameter
     *            The optional parameter name being missed.
     * @param description
     *            The optional error description.
     */
    public MissingParameterResponse( @Nullable final String parameter, @Nullable final String description )
    {
        super(HttpStatus.SC_BAD_REQUEST, "missing_parameter", description);
        this.parameter = parameter;
    }
}
