/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import javax.annotation.Nullable;

import org.apache.http.HttpStatus;

/**
 * Payload Too Large.
 */
public class PayloadTooLargeResponse extends ResponseWithErrorCode
{
    /**
     * Default constructor.
     */
    public PayloadTooLargeResponse()
    {
        this(null);
    }

    /**
     * Constructor with description.
     * 
     * @param description
     *            The optional error description.
     */
    public PayloadTooLargeResponse( @Nullable String description )
    {
        super(HttpStatus.SC_REQUEST_TOO_LONG, "payload_too_large", description);
    }
}
