/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import javax.annotation.Nullable;

import org.apache.http.HttpStatus;

/**
 * Query Signature Error.
 */
public class QuerySignatureErrorResponse extends ResponseWithErrorCode
{
    /**
     * Default constructor.
     */
    public QuerySignatureErrorResponse()
    {
        this(null);
    }

    /**
     * Constructor with description.
     * 
     * @param description
     *            The optional error description.
     */
    public QuerySignatureErrorResponse( @Nullable String description )
    {
        super(HttpStatus.SC_INTERNAL_SERVER_ERROR, "query_signature_error", description);
    }
}
