/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import javax.annotation.Nullable;

import org.apache.http.HttpStatus;

/**
 * Request Execution Error.
 */
public class RequestExecutionErrorResponse extends ResponseWithErrorCode
{
    /**
     * Default constructor.
     */
    public RequestExecutionErrorResponse()
    {
        this(null);
    }

    /**
     * Constructor with description.
     * 
     * @param description
     *            The optional error description.
     */
    public RequestExecutionErrorResponse( @Nullable final String description )
    {
        super(HttpStatus.SC_INTERNAL_SERVER_ERROR, "query_execution_error", description);
    }
}
