/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import javax.annotation.Nullable;

import org.apache.http.HttpStatus;

/**
 * Service Not Available.
 */
public class ServiceNotAvailableResponse extends ResponseWithErrorCode
{
    /**
     * Default constructor.
     */
    public ServiceNotAvailableResponse()
    {
        this(null);
    }

    /**
     * Constructor with description.
     * 
     * @param description
     *            The optional error description.
     */
    public ServiceNotAvailableResponse( @Nullable String description )
    {
        super(HttpStatus.SC_INTERNAL_SERVER_ERROR, "service_not_available", description);
    }
}
