/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import javax.annotation.Nullable;

import org.apache.http.HttpStatus;

/**
 * Unexpected Error.
 */
public class UnexpectedErrorResponse extends ResponseWithErrorCode
{
    /**
     * Default constructor.
     */
    public UnexpectedErrorResponse()
    {
        this(null);
    }

    /**
     * Constructor with description.
     * 
     * @param description
     *            The optional error description.
     */
    public UnexpectedErrorResponse( @Nullable final String description )
    {
        super(HttpStatus.SC_INTERNAL_SERVER_ERROR, "unexpected_error", description);
    }
}
