/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response.mapper;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.cloudplatform.exception.EntityNotFoundException;
import com.sap.cloud.sdk.cloudplatform.servlet.response.EntityNotFoundResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.LogLevel;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;

public class EntityNotFoundExceptionMapper extends AbstractResponseMapper<EntityNotFoundException>
{
    @Nonnull
    @Override
    public Class<EntityNotFoundException> getThrowableClass()
    {
        return EntityNotFoundException.class;
    }

    @Nonnull
    @Override
    public ResponseWithErrorCode toResponse( @Nonnull final Throwable throwable )
    {
        final EntityNotFoundException exception = (EntityNotFoundException) throwable;

        return new EntityNotFoundResponse(exception.getEntity().getOrNull(), exception.getMessage());
    }

    @Nullable
    @Override
    public LogLevel getLogLevel( @Nonnull final Throwable throwable )
    {
        return LogLevel.WARNING;
    }
}
