/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response.mapper;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.cloudplatform.servlet.response.InvalidJsonResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;

public class IllegalArgumentExceptionMapper extends AbstractResponseMapper<IllegalArgumentException>
{
    @Nonnull
    @Override
    public Class<IllegalArgumentException> getThrowableClass()
    {
        return IllegalArgumentException.class;
    }

    @Nullable
    @Override
    public ResponseWithErrorCode toResponse( @Nonnull final Throwable throwable )
    {
        return new InvalidJsonResponse();
    }
}
