/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response.mapper;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.cloudplatform.servlet.response.InvalidParameterResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;

public class NumberFormatExceptionMapper extends AbstractResponseMapper<NumberFormatException>
{
    @Nonnull
    @Override
    public Class<NumberFormatException> getThrowableClass()
    {
        return NumberFormatException.class;
    }

    @Nullable
    @Override
    public ResponseWithErrorCode toResponse( @Nonnull final Throwable throwable )
    {
        return new InvalidParameterResponse(null, "Invalid number format.");
    }
}
