/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response.mapper;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.exc.PropertyBindingException;
import com.sap.cloud.sdk.cloudplatform.servlet.response.InvalidJsonResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;

public class PropertyBindingExceptionMapper extends AbstractResponseMapper<PropertyBindingException>
{
    @Nonnull
    @Override
    public Class<PropertyBindingException> getThrowableClass()
    {
        return PropertyBindingException.class;
    }

    @Nullable
    @Override
    public ResponseWithErrorCode toResponse( @Nonnull final Throwable throwable )
    {
        return new InvalidJsonResponse();
    }
}
