/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response.mapper;

import java.util.concurrent.TimeoutException;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ServiceNotAvailableResponse;

public class TimeoutExceptionMapper extends AbstractResponseMapper<TimeoutException>
{
    @Nonnull
    @Override
    public Class<TimeoutException> getThrowableClass()
    {
        return TimeoutException.class;
    }

    @Nullable
    @Override
    public ResponseWithErrorCode toResponse( @Nonnull final Throwable throwable )
    {
        return new ServiceNotAvailableResponse("Operation timed out.");
    }
}
