/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response.serializer;

import java.lang.reflect.Type;
import java.util.Date;

import javax.annotation.Nonnull;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.sap.cloud.sdk.cloudplatform.exception.StringParsingException;
import com.sap.cloud.sdk.cloudplatform.util.StringConverter;

/**
 * Class for serialization of {@link Date} from and to {@link JsonElement}.
 */
public class DateGsonSerializer implements GsonSerializer<Date>
{
    @Override
    @Nonnull
    public JsonElement serialize( final Date date, final Type typeOfSrc, final JsonSerializationContext context )
    {
        final String str = StringConverter.toString(date);

        if( str == null ) {
            return JsonNull.INSTANCE;
        }

        return new JsonPrimitive(str);
    }

    @Override
    @Nonnull
    public Date deserialize( final JsonElement json, final Type typeOfT, final JsonDeserializationContext context )
    {
        try {
            return StringConverter.toDate(json.getAsString());
        }
        catch( final StringParsingException e ) {
            throw new JsonParseException(e);
        }
    }
}
