/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet;

import com.sap.cloud.sdk.cloudplatform.servlet.DefaultRequestFacade;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestFacade;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestThreadContextListener;
import com.sap.cloud.sdk.cloudplatform.servlet.exception.RequestAccessException;
import com.sap.cloud.sdk.cloudplatform.thread.DefaultThreadContext;
import com.sap.cloud.sdk.cloudplatform.thread.Executable;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContext;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextExecutor;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextListener;
import com.sap.cloud.sdk.cloudplatform.thread.exception.ThreadContextExecutionException;
import io.vavr.control.Try;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestAccessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestAccessor.class);
    @Nonnull
    private static RequestFacade requestFacade = new DefaultRequestFacade();
    @Nullable
    private static Supplier<HttpServletRequest> fallbackRequest = null;

    public static void setRequestFacade(@Nullable RequestFacade requestFacade) {
        RequestAccessor.requestFacade = requestFacade == null ? new DefaultRequestFacade() : requestFacade;
    }

    @Nonnull
    public static HttpServletRequest getCurrentRequest() throws RequestAccessException {
        return (HttpServletRequest)RequestAccessor.tryGetCurrentRequest().getOrElseThrow(failure -> {
            if (failure instanceof RequestAccessException) {
                throw (RequestAccessException)failure;
            }
            throw new RequestAccessException("Failed to get current request.", (Throwable)failure);
        });
    }

    @Nonnull
    public static Try<HttpServletRequest> tryGetCurrentRequest() {
        Try<HttpServletRequest> requestTry = requestFacade.tryGetCurrentRequest();
        if (requestTry.isFailure() && fallbackRequest != null) {
            return requestTry.recover(failure -> {
                HttpServletRequest fallback = fallbackRequest.get();
                if (log.isWarnEnabled()) {
                    log.warn("Recovering with fallback request: " + fallback + ".", failure);
                }
                return fallback;
            });
        }
        return requestTry;
    }

    @Nullable
    public static <T> T executeWithRequest(@Nonnull HttpServletRequest request, @Nonnull Callable<T> callable) throws ThreadContextExecutionException {
        return (T)((ThreadContextExecutor)((ThreadContextExecutor)new ThreadContextExecutor().withThreadContext((ThreadContext)new DefaultThreadContext())).withListeners(new ThreadContextListener[]{new RequestThreadContextListener(request)})).execute(callable);
    }

    public static void executeWithRequest(@Nonnull HttpServletRequest request, @Nonnull Executable executable) throws ThreadContextExecutionException {
        RequestAccessor.executeWithRequest(request, () -> {
            executable.execute();
            return null;
        });
    }

    @Nullable
    public static <T> T executeWithFallbackRequest(@Nonnull Supplier<HttpServletRequest> fallbackRequest, @Nonnull Callable<T> callable) throws ThreadContextExecutionException {
        Try<HttpServletRequest> requestTry = RequestAccessor.tryGetCurrentRequest();
        if (requestTry.isSuccess()) {
            try {
                return callable.call();
            }
            catch (ThreadContextExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ThreadContextExecutionException((Throwable)e);
            }
        }
        return RequestAccessor.executeWithRequest(fallbackRequest.get(), callable);
    }

    public static void executeWithFallbackRequest(@Nonnull Supplier<HttpServletRequest> fallbackRequest, @Nonnull Executable executable) throws ThreadContextExecutionException {
        RequestAccessor.executeWithFallbackRequest(fallbackRequest, () -> {
            executable.execute();
            return null;
        });
    }

    @Generated
    private RequestAccessor() {
    }

    @Nonnull
    @Generated
    public static RequestFacade getRequestFacade() {
        return requestFacade;
    }

    @Nullable
    @Generated
    public static Supplier<HttpServletRequest> getFallbackRequest() {
        return fallbackRequest;
    }

    @Generated
    public static void setFallbackRequest(@Nullable Supplier<HttpServletRequest> fallbackRequest) {
        RequestAccessor.fallbackRequest = fallbackRequest;
    }
}

