/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import javax.annotation.Nullable;

import org.apache.http.HttpStatus;

/**
 * Cloud Connector Error.
 */
public class CloudConnectorErrorResponse extends ResponseWithErrorCode
{
    /**
     * Default constructor.
     */
    public CloudConnectorErrorResponse()
    {
        this(null);
    }

    /**
     * Constructor with description.
     * 
     * @param description
     *            The optional error description.
     */
    public CloudConnectorErrorResponse( @Nullable final String description )
    {
        this(HttpStatus.SC_INTERNAL_SERVER_ERROR, description);
    }

    /**
     * Constructor with cloud connector reference.
     * 
     * @param cloudConnectorStatusCode
     *            The Cloud Connector status code.
     * @param description
     *            The optional error description.
     */
    public CloudConnectorErrorResponse( final int cloudConnectorStatusCode, @Nullable final String description )
    {
        super(cloudConnectorStatusCode, "cloud_connector_error", description);
    }
}
