/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.HttpStatus;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.Expose;

import io.vavr.control.Option;

/**
 * Entity Already Exists.
 */
public class EntityAlreadyExistsResponse extends ResponseWithErrorCode
{
    @Nullable
    @Expose
    @JsonProperty
    private String entity;

    /**
     * Get the entity String representation.
     * 
     * @return The entity.
     */
    @JsonIgnore
    @Nonnull
    public Option<String> getEntity()
    {
        return Option.of(entity);
    }

    /**
     * Default constructor.
     */
    public EntityAlreadyExistsResponse()
    {
        this(null, null);
    }

    /**
     * Constructor with entity reference.
     * 
     * @param entity
     *            The optional entity String representation.
     * @param description
     *            The optional error description.
     */
    public EntityAlreadyExistsResponse( @Nullable final String entity, @Nullable final String description )
    {
        super(HttpStatus.SC_BAD_REQUEST, "entity_already_exists", description);
        this.entity = entity;
    }
}
