/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response.mapper;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.cloudplatform.exception.StringParsingException;
import com.sap.cloud.sdk.cloudplatform.servlet.response.InvalidParameterResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.LogLevel;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;

public class StringParsingExceptionMapper extends AbstractResponseMapper<StringParsingException>
{
    @Nonnull
    @Override
    public Class<StringParsingException> getThrowableClass()
    {
        return StringParsingException.class;
    }

    @Nonnull
    @Override
    public LogLevel getLogLevel( @Nonnull final Throwable throwable )
    {
        return LogLevel.WARNING;
    }

    @Nonnull
    @Override
    public ResponseWithErrorCode toResponse( @Nonnull final Throwable throwable )
    {
        final String stringToParse = ((StringParsingException) throwable).getStringToParse();
        return new InvalidParameterResponse(stringToParse, "Failed to parse: " + stringToParse);
    }
}
