/*
 * Copyright (c) 2022 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet;

import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;

import com.sap.cloud.sdk.cloudplatform.thread.Property;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextAccessor;

import io.vavr.control.Try;

/**
 * Facade for retrieving the current {@link HttpServletRequest}.
 */
public class DefaultRequestFacade implements RequestFacade
{
    /**
     * {@inheritDoc}
     */
    @Override
    @Nonnull
    public Try<HttpServletRequest> tryGetCurrentRequest()
    {
        return ThreadContextAccessor
            .tryGetCurrentContext()
            .flatMap(context -> context.<HttpServletRequest> getProperty(RequestThreadContextListener.PROPERTY_REQUEST))
            .map(Property::getValue);
    }
}
