/*
 * Copyright (c) 2022 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.exception;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.cloudplatform.servlet.response.InvalidParameterResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;
import com.sap.cloud.sdk.cloudplatform.servlet.response.WithErrorResponse;

import lombok.Getter;

/**
 * Thrown when a parameter is invalid.
 */
public class InvalidParameterException extends Exception implements WithErrorResponse
{
    private static final long serialVersionUID = 1481370475755901551L;

    @Getter
    @Nullable
    private final String parameter;

    /**
     * Creates the exception given the optional invalid parameter.
     *
     * @param parameter
     *            The invalid parameter.
     */
    public InvalidParameterException( @Nullable final String parameter )
    {
        super("Invalid parameter: " + parameter);
        this.parameter = parameter;
    }

    /**
     * Creates the exception given the optional invalid parameter and cause.
     *
     * @param parameter
     *            The invalid parameter.
     * @param cause
     *            The cause of the exception. *
     */
    public InvalidParameterException( @Nullable final String parameter, @Nullable final Throwable cause )
    {
        super("Invalid parameter: " + parameter, cause);
        this.parameter = parameter;
    }

    /**
     * {@inheritDoc}
     */
    @Nonnull
    @Override
    public ResponseWithErrorCode getErrorResponse()
    {
        return new InvalidParameterResponse(parameter, getMessage());
    }
}
