/*
 * Copyright (c) 2022 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.exception;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.cloudplatform.servlet.response.MissingParameterResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;
import com.sap.cloud.sdk.cloudplatform.servlet.response.WithErrorResponse;

import lombok.Getter;

/**
 * Thrown when a mandatory parameter is missing.
 */
public class MissingParameterException extends Exception implements WithErrorResponse
{
    private static final long serialVersionUID = 8821381773101843425L;

    @Getter
    @Nullable
    private final String parameter;

    /**
     * Exception constructor.
     * 
     * @param parameter
     *            The missing parameter.
     */
    public MissingParameterException( @Nullable final String parameter )
    {
        super("Missing parameter: " + parameter);
        this.parameter = parameter;
    }

    /**
     * Exception constructor.
     * 
     * @param parameter
     *            The missing parameter.
     * @param cause
     *            The exception cause.
     */
    public MissingParameterException( @Nullable final String parameter, @Nullable final Throwable cause )
    {
        super("Missing parameter: " + parameter, cause);
        this.parameter = parameter;
    }

    /**
     * {@inheritDoc}
     */
    @Nonnull
    @Override
    public ResponseWithErrorCode getErrorResponse()
    {
        return new MissingParameterResponse(parameter, getMessage());
    }
}
