/*
 * Copyright (c) 2022 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import javax.annotation.Nullable;

import org.apache.http.HttpStatus;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.Expose;

import lombok.Getter;

/**
 * Destination Error.
 */
public class DestinationErrorResponse extends ResponseWithErrorCode
{
    @Nullable
    @Getter
    @Expose
    @JsonProperty
    private final String destinationName;

    /**
     * Constructor with destination reference.
     * 
     * @param destinationName
     *            The optional destination name.
     * @param message
     *            The optional error message.
     */
    public DestinationErrorResponse( @Nullable final String destinationName, @Nullable final String message )
    {
        super(HttpStatus.SC_INTERNAL_SERVER_ERROR, "destination_error", message);
        this.destinationName = destinationName;
    }
}
