/*
 * Copyright (c) 2022 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import javax.annotation.Nullable;

import org.apache.http.HttpStatus;

/**
 * Missing Configuration.
 */
public class MissingConfigResponse extends ResponseWithErrorCode
{
    /**
     * Default constructor.
     */
    public MissingConfigResponse()
    {
        this(null);
    }

    /**
     * Constructor with description.
     * 
     * @param description
     *            The optional error description.
     */
    public MissingConfigResponse( @Nullable final String description )
    {
        super(HttpStatus.SC_BAD_REQUEST, "missing_config", description);
    }
}
