/*
 * Copyright (c) 2022 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response.mapper;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.cloudplatform.servlet.response.LogLevel;

public abstract class AbstractResponseMapper<T extends Throwable> implements ResponseMapper<T> //NOCHECKSTYLE
{
    /**
     * @return The log level to be used for the given {@link Throwable}. Returning {@code null} indicates the response
     *         builder to use its default behavior.
     */
    @Nullable
    @Override
    public LogLevel getLogLevel( @Nonnull final Throwable throwable )
    {
        return null;
    }

    /**
     * @return The error message to be used for the given {@link Throwable}. Returning {@code null} indicates the
     *         response builder to use its default behavior.
     */
    @Nullable
    @Override
    public String getErrorMessage( @Nonnull final Throwable throwable )
    {
        return null;
    }
}
