/*
 * Copyright (c) 2022 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response.mapper;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.google.gson.JsonSyntaxException;
import com.sap.cloud.sdk.cloudplatform.servlet.response.InvalidJsonResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;

public class JsonSyntaxExceptionMapper extends AbstractResponseMapper<JsonSyntaxException>
{
    @Nonnull
    @Override
    public Class<JsonSyntaxException> getThrowableClass()
    {
        return JsonSyntaxException.class;
    }

    @Nullable
    @Override
    public ResponseWithErrorCode toResponse( @Nonnull final Throwable throwable )
    {
        return new InvalidJsonResponse();
    }
}
