/*
 * Copyright (c) 2022 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response.serializer;

import java.lang.reflect.Type;
import java.util.Date;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.sap.cloud.sdk.cloudplatform.exception.StringParsingException;
import com.sap.cloud.sdk.cloudplatform.util.StringConverter;

/**
 * Class for serialization of {@link Date} from and to {@link JsonElement}.
 */
public class DateGsonSerializer implements GsonSerializer<Date>
{
    @Override
    @Nonnull
    public JsonElement serialize(
        @Nullable final Date date,
        @Nonnull final Type typeOfSrc,
        @Nonnull final JsonSerializationContext context )
    {
        final String str = StringConverter.toString(date);

        if( str == null ) {
            return JsonNull.INSTANCE;
        }

        return new JsonPrimitive(str);
    }

    @Override
    @Nullable
    public Date deserialize(
        @Nonnull final JsonElement json,
        @Nonnull final Type typeOfT,
        @Nonnull final JsonDeserializationContext context )
    {
        try {
            return StringConverter.toDate(json.getAsString());
        }
        catch( final StringParsingException e ) {
            throw new JsonParseException(e);
        }
    }
}
