/*
 * Copyright (c) 2022 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet;

import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;

import io.vavr.control.Try;

/**
 * Facade interface encapsulating the logic to access the current {@link HttpServletRequest}.
 */
@FunctionalInterface
public interface RequestFacade
{
    /**
     * Returns a {@link Try} of the current {@link HttpServletRequest}.
     *
     * @return A {@link Try} of the current {@link HttpServletRequest}.
     */
    @Nonnull
    Try<HttpServletRequest> tryGetCurrentRequest();
}
