/*
 * Copyright (c) 2022 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.exception;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ServiceNotAvailableResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.WithErrorResponse;

import lombok.NoArgsConstructor;

/**
 * Thrown when a service is not available.
 */
@NoArgsConstructor
public class ServiceNotAvailableException extends Exception implements WithErrorResponse
{
    private static final long serialVersionUID = -1448954954825280215L;

    /**
     * Exception constructor.
     * 
     * @param message
     *            The exception message.
     */
    public ServiceNotAvailableException( @Nullable final String message )
    {
        super(message);
    }

    /**
     * Exception constructor.
     * 
     * @param cause
     *            The exception cause.
     */
    public ServiceNotAvailableException( @Nullable final Throwable cause )
    {
        super(cause);
    }

    /**
     * Exception constructor.
     * 
     * @param message
     *            The exception message.
     * @param cause
     *            The exception cause.
     */
    public ServiceNotAvailableException( @Nullable final String message, @Nullable final Throwable cause )
    {
        super(message, cause);
    }

    @Nonnull
    @Override
    public ResponseWithErrorCode getErrorResponse()
    {
        return new ServiceNotAvailableResponse(getMessage());
    }
}
