/*
 * Copyright (c) 2022 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import javax.annotation.Nullable;

import org.apache.http.HttpStatus;

/**
 * Logon Error.
 */
public class LogonErrorResponse extends ResponseWithErrorCode
{
    /**
     * Default constructor.
     */
    public LogonErrorResponse()
    {
        this(null);
    }

    /**
     * Constructor with description.
     * 
     * @param description
     *            The optional error description.
     */
    public LogonErrorResponse( @Nullable final String description )
    {
        super(HttpStatus.SC_UNAUTHORIZED, "logon_error", description);
    }
}
