/*
 * Copyright (c) 2022 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import javax.annotation.Nullable;

import org.apache.http.HttpStatus;

/**
 * Not Authenticated.
 */
public class NotAuthenticatedResponse extends ResponseWithErrorCode
{
    /**
     * Default constructor.
     */
    public NotAuthenticatedResponse()
    {
        this(null);
    }

    /**
     * Constructor with description.
     * 
     * @param description
     *            The optional error description.
     */
    public NotAuthenticatedResponse( @Nullable final String description )
    {
        super(HttpStatus.SC_UNAUTHORIZED, "not_authenticated", description);
    }
}
